/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5332")
public class ClearTextProtocolCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, Protocol> PROTOCOLS = new HashMap<String, Protocol>();
    private static final String MESSAGE = "Using %s protocol is insecure. Use %s instead.";
    private static final String MESSAGE_HTTP = "Using HTTP protocol is insecure. Use HTTPS instead.";
    private static final String MESSAGE_ANDROID_MIXED_CONTENT = "Using a relaxed mixed content policy is security-sensitive.";
    private static final MethodMatchers UNSECURE_CLIENTS;
    private static final MethodMatchers OK_HTTP_CONNECTION_SPEC_BUILDERS;
    private static final MethodMatchers OK_HTTP_BUILDERS;
    private static final MethodMatchers ANDROID_SET_MIXED_CONTENT_MODE;
    public static final Integer MIXED_CONTENT_ALWAYS_ALLOW;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTree newClassTree = (NewClassTree)tree;
            if (UNSECURE_CLIENTS.matches(newClassTree)) {
                Protocol protocol = PROTOCOLS.get(newClassTree.symbolType().fullyQualifiedName());
                String message = String.format(MESSAGE, protocol.protocolName, protocol.alternatives);
                this.reportIssue((Tree)newClassTree.identifier(), message);
            } else if (OK_HTTP_CONNECTION_SPEC_BUILDERS.matches(newClassTree)) {
                this.reportIfUsesClearText(newClassTree.arguments());
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (OK_HTTP_BUILDERS.matches(mit)) {
                this.reportIfUsesClearText(mit.arguments());
            } else if (ANDROID_SET_MIXED_CONTENT_MODE.matches(mit)) {
                this.reportIfAlwaysAllow((ExpressionTree)mit.arguments().get(0));
            }
        }
    }

    private void reportIfAlwaysAllow(ExpressionTree setMixedContentModeArgument) {
        if (MIXED_CONTENT_ALWAYS_ALLOW.equals(ExpressionUtils.resolveAsConstant((ExpressionTree)setMixedContentModeArgument))) {
            this.reportIssue((Tree)setMixedContentModeArgument, MESSAGE_ANDROID_MIXED_CONTENT);
        }
    }

    private void reportIfUsesClearText(Arguments arguments) {
        arguments.accept((TreeVisitor)new ClearTextVisitor());
    }

    static {
        PROTOCOLS.put("org.apache.commons.net.ftp.FTPClient", new Protocol("FTP", "SFTP, SCP or FTPS"));
        PROTOCOLS.put("org.apache.commons.net.smtp.SMTPClient", new Protocol("clear-text SMTP", "SMTP over SSL/TLS or SMTP with STARTTLS"));
        PROTOCOLS.put("org.apache.commons.net.telnet.TelnetClient", new Protocol("Telnet", "SSH"));
        UNSECURE_CLIENTS = MethodMatchers.create().ofTypes(PROTOCOLS.keySet().toArray(new String[0])).constructor().withAnyParameters().build();
        OK_HTTP_CONNECTION_SPEC_BUILDERS = MethodMatchers.create().ofTypes(new String[]{"okhttp3.ConnectionSpec$Builder"}).constructor().addParametersMatcher(new String[]{"okhttp3.ConnectionSpec"}).build();
        OK_HTTP_BUILDERS = MethodMatchers.create().ofTypes(new String[]{"okhttp3.OkHttpClient$Builder"}).names(new String[]{"connectionSpecs"}).addParametersMatcher(new String[]{"*"}).build();
        ANDROID_SET_MIXED_CONTENT_MODE = MethodMatchers.create().ofSubTypes(new String[]{"android.webkit.WebSettings"}).names(new String[]{"setMixedContentMode"}).addParametersMatcher(new String[]{"int"}).build();
        MIXED_CONTENT_ALWAYS_ALLOW = 0;
    }

    private static class Protocol {
        String protocolName;
        String alternatives;

        Protocol(String protocolName, String alternatives) {
            this.protocolName = protocolName;
            this.alternatives = alternatives;
        }
    }

    class ClearTextVisitor
    extends BaseTreeVisitor {
        ClearTextVisitor() {
        }

        public void visitIdentifier(IdentifierTree tree) {
            if ("CLEARTEXT".equals(tree.name())) {
                ClearTextProtocolCheck.this.reportIssue((Tree)tree, ClearTextProtocolCheck.MESSAGE_HTTP);
            }
        }
    }
}

