/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5527")
public class VerifiedServerHostnamesCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "Enable server hostname verification on this SSL/TLS connection.";
    private static final String JAVAX_NET_SSL_HOSTNAME_VERIFIER = "javax.net.ssl.HostnameVerifier";
    private static final MethodMatchers HOSTNAME_VERIFIER = MethodMatchers.create().ofSubTypes(new String[]{"javax.net.ssl.HostnameVerifier"}).names(new String[]{"verify"}).addParametersMatcher(new String[]{"java.lang.String", "javax.net.ssl.SSLSession"}).build();
    private static final String APACHE_EMAIL = "org.apache.commons.mail.Email";
    private static final Set<String> ENABLING_SSL_METHOD_NAMES = new HashSet<String>(Arrays.asList("setSSL", "setSSLOnConnect", "setTLS", "setStartTLSEnabled", "setStartTLSRequired"));
    private static final MethodMatchers ENABLING_SSL_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.commons.mail.Email"}).name(ENABLING_SSL_METHOD_NAMES::contains).addParametersMatcher(new String[]{"boolean"}).build();
    private static final MethodMatchers HASHTABLE_PUT = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Hashtable"}).names(new String[]{"put"}).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case METHOD: {
                this.checkMethodDefinition((MethodTree)tree);
                break;
            }
            case LAMBDA_EXPRESSION: {
                this.checkLambdaDefinition((LambdaExpressionTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                this.checkMethodInvocation((MethodInvocationTree)tree);
                break;
            }
        }
    }

    private void checkMethodDefinition(MethodTree tree) {
        BlockTree blockTree = tree.block();
        if (blockTree == null) {
            return;
        }
        if (HOSTNAME_VERIFIER.matches(tree)) {
            this.checkBlock(blockTree);
        }
    }

    private void checkLambdaDefinition(LambdaExpressionTree lambdaExpression) {
        Tree lambdaBody = lambdaExpression.body();
        if (VerifiedServerHostnamesCheck.isHostnameVerifierSignature(lambdaExpression)) {
            if (lambdaBody.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                this.checkBlock((BlockTree)lambdaBody);
            } else if (VerifiedServerHostnamesCheck.isTrueLiteral(lambdaBody)) {
                this.reportIssue(lambdaBody, ISSUE_MESSAGE);
            }
        }
    }

    private void checkBlock(BlockTree blockTree) {
        List innerBlock = blockTree.body();
        while (innerBlock.size() == 1 && ((StatementTree)innerBlock.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            innerBlock = ((BlockTree)innerBlock.get(0)).body();
        }
        List<StatementTree> statementTreeList = innerBlock.stream().filter(statementTree -> !statementTree.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})).collect(Collectors.toList());
        if (VerifiedServerHostnamesCheck.isReturnTrueStatement(statementTreeList)) {
            this.reportIssue((Tree)statementTreeList.get(0), ISSUE_MESSAGE);
        }
    }

    private static boolean isHostnameVerifierSignature(LambdaExpressionTree lambdaExpressionTree) {
        return lambdaExpressionTree.symbolType().isSubtypeOf(JAVAX_NET_SSL_HOSTNAME_VERIFIER);
    }

    private static boolean isReturnTrueStatement(List<StatementTree> statementTreeList) {
        if (statementTreeList.size() == 1 && statementTreeList.get(0).is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ExpressionTree expression = ((ReturnStatementTree)statementTreeList.get(0)).expression();
            return VerifiedServerHostnamesCheck.isTrueLiteral((Tree)expression);
        }
        return false;
    }

    private static boolean isTrueLiteral(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION}) || tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)tree));
            return LiteralUtils.isTrue((Tree)expression);
        }
        return false;
    }

    private void checkMethodInvocation(MethodInvocationTree mit) {
        MethodTree method = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
        if (method == null) {
            return;
        }
        ExpressionTree methodSelect = mit.methodSelect();
        if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return;
        }
        Symbol extractedIdentifier = ExpressionUtils.extractIdentifierSymbol((ExpressionTree)((MemberSelectExpressionTree)methodSelect).expression()).orElse(null);
        if (ENABLING_SSL_METHODS.matches(mit) && LiteralUtils.isTrue((Tree)((Tree)mit.arguments().get(0)))) {
            MethodBodyApacheVisitor apacheVisitor = new MethodBodyApacheVisitor(extractedIdentifier);
            method.accept((TreeVisitor)apacheVisitor);
            if (!apacheVisitor.isSecured) {
                this.reportIssue((Tree)mit, ISSUE_MESSAGE);
            }
        } else if (HASHTABLE_PUT.matches(mit) && VerifiedServerHostnamesCheck.isSettingSSL(mit.arguments())) {
            MethodBodyHashtableVisitor hashtableVisitor = new MethodBodyHashtableVisitor(extractedIdentifier);
            method.accept((TreeVisitor)hashtableVisitor);
            if (!hashtableVisitor.isSecured) {
                this.reportIssue((Tree)mit, "Enable server hostname verification on this SSL/TLS connection, by setting \"mail.smtp.ssl.checkserveridentity\" to true.");
            }
        }
    }

    private static boolean isSettingSSL(Arguments args) {
        return "mail.smtp.socketFactory.class".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)args.get(0)).value()) && "javax.net.ssl.SSLSocketFactory".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)args.get(1)).value());
    }

    private static boolean isNotFalse(ExpressionTree expression) {
        return !LiteralUtils.isFalse((Tree)expression);
    }

    private static class MethodBodyApacheVisitor
    extends BaseTreeVisitor {
        private boolean isSecured = false;
        private Symbol variable;
        private static final MethodMatchers SET_SSL_CHECK_SERVER_ID = MethodMatchers.create().ofSubTypes(new String[]{"org.apache.commons.mail.Email"}).names(new String[]{"setSSLCheckServerIdentity"}).addParametersMatcher(new String[]{"boolean"}).build();

        MethodBodyApacheVisitor(@Nullable Symbol variable) {
            this.variable = variable;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (ExpressionUtils.isInvocationOnVariable((MethodInvocationTree)mit, (Symbol)this.variable, (boolean)true) && SET_SSL_CHECK_SERVER_ID.matches(mit) && VerifiedServerHostnamesCheck.isNotFalse((ExpressionTree)mit.arguments().get(0))) {
                this.isSecured = true;
            }
            super.visitMethodInvocation(mit);
        }
    }

    private static class MethodBodyHashtableVisitor
    extends BaseTreeVisitor {
        private boolean isSecured = false;
        private Symbol variable;

        MethodBodyHashtableVisitor(@Nullable Symbol variable) {
            this.variable = variable;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (ExpressionUtils.isInvocationOnVariable((MethodInvocationTree)mit, (Symbol)this.variable, (boolean)true)) {
                Arguments args = mit.arguments();
                if (HASHTABLE_PUT.matches(mit) && "mail.smtp.ssl.checkserveridentity".equals(ExpressionsHelper.getConstantValueAsString((ExpressionTree)args.get(0)).value()) && VerifiedServerHostnamesCheck.isNotFalse((ExpressionTree)args.get(1))) {
                    this.isSecured = true;
                }
            }
            super.visitMethodInvocation(mit);
        }
    }
}

