/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2055")
public class SerializableSuperConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers WRITE_REPLACE = MethodMatchers.create().ofAnyType().names(new String[]{"writeReplace"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.simpleName() == null) {
            return;
        }
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        Type superclass = classSymbol.superClass();
        if (SerializableSuperConstructorCheck.isSerializable(classSymbol.type()) && SerializableSuperConstructorCheck.isNotSerializableMissingNoArgConstructor(superclass) && !SerializableSuperConstructorCheck.implementsSerializableMethods(classSymbol)) {
            this.reportIssue((Tree)classTree.superClass(), "Add a no-arg constructor to \"" + superclass.name() + "\".");
        }
    }

    private static boolean isNotSerializableMissingNoArgConstructor(@Nullable Type superclass) {
        return superclass != null && !superclass.isUnknown() && !SerializableSuperConstructorCheck.isSerializable(superclass) && !SerializableSuperConstructorCheck.hasNonPrivateNoArgConstructor(superclass);
    }

    private static boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private static boolean hasNonPrivateNoArgConstructor(Type type) {
        Collection constructors = type.symbol().lookupSymbols("<init>");
        for (Symbol member : constructors) {
            Symbol.MethodSymbol method;
            if (!member.isMethodSymbol() || !(method = (Symbol.MethodSymbol)member).parameterTypes().isEmpty() || method.isPrivate()) continue;
            return true;
        }
        return constructors.isEmpty();
    }

    private static boolean implementsSerializableMethods(Symbol.TypeSymbol classSymbol) {
        return classSymbol.memberSymbols().stream().anyMatch(arg_0 -> ((MethodMatchers)WRITE_REPLACE).matches(arg_0));
    }
}

