/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1068")
public class UnusedPrivateFieldCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] ASSIGNMENT_KINDS = new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT};
    private final List<ClassTree> classes = new ArrayList<ClassTree>();
    private final Map<Symbol, List<AssignmentExpressionTree>> assignments = new HashMap<Symbol, List<AssignmentExpressionTree>>();
    private final Set<String> unknownIdentifiers = new HashSet<String>();
    private boolean hasNativeMethod = false;

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.IDENTIFIER);
    }

    public void setContext(JavaFileScannerContext context) {
        this.clearState();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        if (!this.hasNativeMethod) {
            this.classes.forEach(this::checkClassFields);
        }
        this.clearState();
    }

    private void clearState() {
        this.classes.clear();
        this.assignments.clear();
        this.unknownIdentifiers.clear();
        this.hasNativeMethod = false;
    }

    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case METHOD: {
                this.checkIfNativeMethod((MethodTree)tree);
                break;
            }
            case CLASS: {
                this.classes.add((ClassTree)tree);
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.collectAssignment(((ExpressionStatementTree)tree).expression());
                break;
            }
            case IDENTIFIER: {
                this.collectUnknownIdentifier((IdentifierTree)tree);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected subscribed tree.");
            }
        }
    }

    private void collectUnknownIdentifier(IdentifierTree identifier) {
        if (identifier.symbol().isUnknown() && !UnusedPrivateFieldCheck.isMethodIdentifier(identifier)) {
            this.unknownIdentifiers.add(identifier.name());
        }
    }

    private static boolean isMethodIdentifier(IdentifierTree identifier) {
        Tree parent;
        for (parent = identifier.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE}); parent = parent.parent()) {
        }
        if (parent == null) {
            return false;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return identifier.equals((Object)ExpressionUtils.methodName((MethodInvocationTree)((MethodInvocationTree)parent)));
        }
        return identifier.equals((Object)((MethodReferenceTree)parent).method());
    }

    private void checkIfNativeMethod(MethodTree method) {
        if (ModifiersUtils.hasModifier((ModifiersTree)method.modifiers(), (Modifier)Modifier.NATIVE)) {
            this.hasNativeMethod = true;
        }
    }

    private void checkClassFields(ClassTree classTree) {
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).forEach(this::checkIfUnused);
    }

    public void checkIfUnused(VariableTree tree) {
        if (UnusedPrivateFieldCheck.hasNoAnnotation(tree)) {
            Symbol symbol = tree.symbol();
            String name = symbol.name();
            if (symbol.isPrivate() && this.onlyUsedInVariableAssignment(symbol) && !"serialVersionUID".equals(name) && !this.unknownIdentifiers.contains(name)) {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)tree.simpleName()).withMessage("Remove this unused \"" + name + "\" private field.").withQuickFix(() -> this.computeQuickFix(tree, this.assignments.getOrDefault(symbol, Collections.emptyList()))).report();
            }
        }
    }

    private boolean onlyUsedInVariableAssignment(Symbol symbol) {
        return symbol.usages().size() == this.assignments.getOrDefault(symbol, Collections.emptyList()).size();
    }

    private static boolean hasNoAnnotation(VariableTree tree) {
        return tree.modifiers().annotations().isEmpty();
    }

    private void collectAssignment(ExpressionTree expressionTree) {
        if (expressionTree.is(ASSIGNMENT_KINDS)) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)expressionTree;
            ExpressionTree variable = assignmentExpressionTree.variable();
            IdentifierTree identifier = null;
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                identifier = (IdentifierTree)variable;
            } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                identifier = ((MemberSelectExpressionTree)variable).identifier();
            } else {
                return;
            }
            Symbol reference = identifier.symbol();
            if (!reference.isUnknown()) {
                List assignmentsToVariable = this.assignments.computeIfAbsent(reference, k -> new ArrayList());
                assignmentsToVariable.add(assignmentExpressionTree);
            }
        }
    }

    private JavaQuickFix computeQuickFix(VariableTree tree, List<AssignmentExpressionTree> assignments) {
        AnalyzerMessage.TextSpan textSpan = UnusedPrivateFieldCheck.computeTextSpan(tree);
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>(assignments.size() + 1);
        edits.addAll(this.computeExpressionCaptures(assignments));
        edits.add(JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)textSpan));
        return JavaQuickFix.newQuickFix((String)"Remove this unused private field").addTextEdits(edits).reverseSortEdits().build();
    }

    private static AnalyzerMessage.TextSpan computeTextSpan(VariableTree tree) {
        SyntaxTrivia lastTrivia;
        Optional<VariableTree> followingVariable = QuickFixHelper.nextVariable(tree);
        if (followingVariable.isPresent()) {
            return AnalyzerMessage.textSpanBetween((Tree)tree.simpleName(), (boolean)true, (Tree)followingVariable.get().simpleName(), (boolean)false);
        }
        Optional<SyntaxToken> precedingComma = UnusedPrivateFieldCheck.getPrecedingComma(tree);
        if (precedingComma.isPresent()) {
            SyntaxToken endingSemiColon = tree.lastToken();
            return AnalyzerMessage.textSpanBetween((Tree)((Tree)precedingComma.get()), (boolean)true, (Tree)endingSemiColon, (boolean)false);
        }
        List trivias = tree.firstToken().trivias();
        if (!trivias.isEmpty() && (lastTrivia = (SyntaxTrivia)trivias.get(trivias.size() - 1)).comment().startsWith("/**")) {
            SyntaxToken lastToken = tree.lastToken();
            Position start = Position.startOf((SyntaxTrivia)lastTrivia);
            Position end = Position.endOf((SyntaxToken)lastToken);
            return JavaTextEdit.textSpan((int)start.line(), (int)start.columnOffset(), (int)end.line(), (int)end.columnOffset());
        }
        return AnalyzerMessage.textSpanFor((Tree)tree);
    }

    private List<JavaTextEdit> computeExpressionCaptures(List<AssignmentExpressionTree> assignments) {
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        for (int i = 1; i <= assignments.size(); ++i) {
            AssignmentExpressionTree assignment = assignments.get(i - 1);
            ExpressionTree variable = assignment.variable();
            String replacement = this.computeReplacement(variable, i);
            edits.add(JavaTextEdit.replaceBetweenTree((Tree)variable, (boolean)true, (Tree)assignment.expression(), (boolean)false, (String)replacement));
        }
        return edits;
    }

    private String computeReplacement(ExpressionTree variable, int index) {
        IdentifierTree identifier;
        Object name = "";
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifier = (IdentifierTree)variable;
            name = identifier.name() + index;
        } else {
            identifier = ((MemberSelectExpressionTree)variable).identifier();
            name = identifier.name() + index;
        }
        name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
        TypeTree typeInDeclaration = ((VariableTree)identifier.symbol().declaration()).type();
        String type = QuickFixHelper.contentForTree((Tree)typeInDeclaration, this.context);
        return String.format("%s valueFormerlyAssignedTo%s = ", type, name);
    }

    private static Optional<SyntaxToken> getPrecedingComma(VariableTree variable) {
        return QuickFixHelper.previousVariable(variable).map(Tree::lastToken);
    }
}

