/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

public abstract class AbstractHashAlgorithmChecker
extends AbstractMethodDetection {
    public static final String GET_INSTANCE = "getInstance";
    public static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final Map<String, InsecureAlgorithm> ALGORITHM_BY_METHOD_NAME = MapBuilder.newMap().put((Object)"getMd2Digest", (Object)InsecureAlgorithm.MD2).put((Object)"getMd5Digest", (Object)InsecureAlgorithm.MD5).put((Object)"getShaDigest", (Object)InsecureAlgorithm.SHA1).put((Object)"getSha1Digest", (Object)InsecureAlgorithm.SHA1).put((Object)"md2", (Object)InsecureAlgorithm.MD2).put((Object)"md2Hex", (Object)InsecureAlgorithm.MD2).put((Object)"md5", (Object)InsecureAlgorithm.MD5).put((Object)"md5Hex", (Object)InsecureAlgorithm.MD5).put((Object)"sha1", (Object)InsecureAlgorithm.SHA1).put((Object)"sha1Hex", (Object)InsecureAlgorithm.SHA1).put((Object)"sha", (Object)InsecureAlgorithm.SHA1).put((Object)"shaHex", (Object)InsecureAlgorithm.SHA1).put((Object)"md5Digest", (Object)InsecureAlgorithm.MD5).put((Object)"md5DigestAsHex", (Object)InsecureAlgorithm.MD5).put((Object)"appendMd5DigestAsHex", (Object)InsecureAlgorithm.MD5).build();
    private static final String CONSTRUCTOR = "<init>";
    private static final String[] CRYPTO_APIS = new String[]{"java.security.AlgorithmParameters", "java.security.AlgorithmParameterGenerator", "java.security.MessageDigest", "java.security.KeyFactory", "java.security.KeyPairGenerator", "java.security.Signature", "javax.crypto.Mac", "javax.crypto.KeyGenerator"};

    protected abstract Optional<String> getMessageForClass(String var1);

    protected abstract String getMessageForAlgorithm(String var1);

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return AbstractHashAlgorithmChecker.getWeakHashMethodInvocationMatchers();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
        Optional<String> message = this.getMessageForClass(methodName.symbol().owner().type().fullyQualifiedName());
        if (message.isPresent()) {
            this.reportIssue((Tree)methodName, message.get());
            return;
        }
        InsecureAlgorithm algorithm = ALGORITHM_BY_METHOD_NAME.get(methodName.name());
        if (algorithm == null) {
            algorithm = AbstractHashAlgorithmChecker.algorithm((ExpressionTree)mit.arguments().get(0)).orElse(null);
        }
        if (algorithm != null) {
            this.reportIssue((Tree)methodName, this.getMessageForAlgorithm(algorithm.toString()));
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.getMessageForClass(newClassTree.identifier().symbolType().fullyQualifiedName()).ifPresent(message -> this.reportIssue((Tree)newClassTree.identifier(), (String)message));
    }

    private static MethodMatchers getWeakHashMethodInvocationMatchers() {
        ArrayList<MethodMatchers> matchers = new ArrayList<MethodMatchers>();
        matchers.add(MethodMatchers.create().ofTypes(new String[]{"org.apache.commons.codec.digest.DigestUtils"}).names(new String[]{"getDigest"}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).build());
        matchers.add(MethodMatchers.create().ofTypes(new String[]{"org.apache.commons.codec.digest.DigestUtils"}).name(ALGORITHM_BY_METHOD_NAME::containsKey).withAnyParameters().build());
        matchers.add(MethodMatchers.create().ofTypes(CRYPTO_APIS).names(new String[]{GET_INSTANCE}).addParametersMatcher(new String[]{JAVA_LANG_STRING}).addParametersMatcher(new String[]{JAVA_LANG_STRING, "*"}).build());
        matchers.add(MethodMatchers.create().ofTypes(new String[]{"org.springframework.util.DigestUtils"}).names(new String[]{"appendMd5DigestAsHex", "md5Digest", "md5DigestAsHex"}).withAnyParameters().build());
        for (DeprecatedSpringPasswordEncoder pe : DeprecatedSpringPasswordEncoder.values()) {
            matchers.add(MethodMatchers.create().ofTypes(new String[]{pe.classFqn}).names(new String[]{pe.methodName}).withAnyParameters().build());
        }
        matchers.add(MethodMatchers.create().ofTypes(new String[]{"com.google.common.hash.Hashing"}).names(new String[]{"md5", "sha1"}).addWithoutParametersMatcher().build());
        return MethodMatchers.or(matchers);
    }

    private static Optional<InsecureAlgorithm> algorithm(ExpressionTree invocationArgument) {
        Optional stringConstant;
        ExpressionTree expectedAlgorithm = invocationArgument;
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(invocationArgument);
        if (defaultPropertyValue != null) {
            expectedAlgorithm = defaultPropertyValue;
        }
        if ((stringConstant = expectedAlgorithm.asConstant(String.class)).isPresent()) {
            String algorithmName = (String)stringConstant.get();
            return Arrays.stream(InsecureAlgorithm.values()).filter(alg -> alg.match(algorithmName)).findFirst();
        }
        return Optional.empty();
    }

    public static enum InsecureAlgorithm {
        MD2,
        MD4,
        MD5,
        MD6,
        RIPEMD,
        HAVAL128{

            public String toString() {
                return "HAVAL-128";
            }
        }
        ,
        SHA{

            @Override
            public boolean match(String algorithm) {
                return "SHA".equals(algorithm);
            }
        }
        ,
        SHA0{

            public String toString() {
                return "SHA-0";
            }
        }
        ,
        SHA1{

            public String toString() {
                return "SHA-1";
            }
        }
        ,
        SHA224{

            public String toString() {
                return "SHA-224";
            }
        }
        ,
        DSA{

            @Override
            public boolean match(String algorithm) {
                return "DSA".equals(algorithm);
            }
        };


        public boolean match(String algorithm) {
            String normalizedName = algorithm.replace("-", "").toLowerCase(Locale.ENGLISH);
            return normalizedName.contains(this.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public static enum DeprecatedSpringPasswordEncoder {
        MD5("org.springframework.security.authentication.encoding.Md5PasswordEncoder", "<init>"),
        SHA("org.springframework.security.authentication.encoding.ShaPasswordEncoder", "<init>"),
        LDAP("org.springframework.security.crypto.password.LdapShaPasswordEncoder", "<init>"),
        MD4("org.springframework.security.crypto.password.Md4PasswordEncoder", "<init>"),
        MESSAGE_DIGEST("org.springframework.security.crypto.password.MessageDigestPasswordEncoder", "<init>"),
        STANDARD("org.springframework.security.crypto.password.StandardPasswordEncoder", "<init>"),
        NO_OP("org.springframework.security.crypto.password.NoOpPasswordEncoder", "getInstance");

        public final String classFqn;
        public final String methodName;
        public final String className;

        private DeprecatedSpringPasswordEncoder(String fqn, String methodName) {
            this.classFqn = fqn;
            this.methodName = methodName;
            String[] fqnParts = fqn.split("\\.");
            this.className = fqnParts[fqnParts.length - 1];
        }
    }
}

