/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1604")
public class AnonymousClassShouldBeLambdaCheck
extends BaseTreeVisitor
implements JavaFileScanner,
JavaVersionAwareVisitor {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private JavaFileScannerContext context;
    private final Set<IdentifierTree> enumConstants = new HashSet<IdentifierTree>();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.enumConstants.clear();
        this.scan((Tree)context.getTree());
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.enumConstants.add(tree.simpleName());
        super.visitEnumConstant(tree);
        this.enumConstants.remove(tree.simpleName());
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        ClassTree classBody = tree.classBody();
        if (classBody != null) {
            TypeTree identifier = tree.identifier();
            if (!AnonymousClassShouldBeLambdaCheck.useThisInstance(classBody) && !this.enumConstants.contains(identifier) && AnonymousClassShouldBeLambdaCheck.isSAM(classBody)) {
                this.context.reportIssue((JavaCheck)this, (Tree)identifier, "Make this anonymous inner class a lambda" + this.context.getJavaVersion().java8CompatibilityMessage());
            }
        }
    }

    private static boolean isSAM(ClassTree classBody) {
        if (AnonymousClassShouldBeLambdaCheck.hasOnlyOneMethod(classBody.members())) {
            Symbol.TypeSymbol symbol = classBody.symbol();
            return symbol.interfaces().size() == 1 && symbol.superClass().is(JAVA_LANG_OBJECT) && AnonymousClassShouldBeLambdaCheck.hasSingleAbstractMethodInHierarchy(JUtils.superTypes((Symbol.TypeSymbol)symbol));
        }
        return false;
    }

    private static boolean hasSingleAbstractMethodInHierarchy(Set<Type> superTypes) {
        return superTypes.stream().filter(type -> !type.is(JAVA_LANG_OBJECT)).map(Type::symbol).flatMap(superType -> superType.memberSymbols().stream().filter(Symbol::isMethodSymbol).filter(Symbol::isAbstract)).map(Symbol.MethodSymbol.class::cast).filter(symbol -> !AnonymousClassShouldBeLambdaCheck.isObjectMethod(symbol)).filter(symbol -> !JUtils.isParametrizedMethod((Symbol.MethodSymbol)symbol)).map(AnonymousClassShouldBeLambdaCheck::overridenSymbolIfAny).collect(Collectors.toSet()).size() == 1;
    }

    private static Symbol.MethodSymbol overridenSymbolIfAny(Symbol.MethodSymbol symbol) {
        return symbol.overriddenSymbols().stream().findFirst().orElse(symbol);
    }

    private static boolean isObjectMethod(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol.overriddenSymbols().stream().map(Symbol::owner).map(Symbol::type).anyMatch(t -> t.is(JAVA_LANG_OBJECT));
    }

    private static boolean hasOnlyOneMethod(List<Tree> members) {
        MethodTree methodTree = null;
        for (Tree tree : members) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT, Tree.Kind.METHOD})) {
                return false;
            }
            if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            if (methodTree != null) {
                return false;
            }
            methodTree = (MethodTree)tree;
        }
        return methodTree != null && AnonymousClassShouldBeLambdaCheck.canRefactorMethod(methodTree);
    }

    private static boolean canRefactorMethod(MethodTree methodTree) {
        return methodTree.throwsClauses().isEmpty() && methodTree.symbol().metadata().annotations().stream().allMatch(annotation -> annotation.symbol().type().is("java.lang.Override"));
    }

    private static boolean useThisInstance(ClassTree body) {
        UsesThisInstanceVisitor visitor = new UsesThisInstanceVisitor(body.symbol().type());
        body.accept((TreeVisitor)visitor);
        return visitor.usesThisInstance;
    }

    private static class UsesThisInstanceVisitor
    extends BaseTreeVisitor {
        private final Type instanceType;
        boolean usesThisInstance = false;
        boolean visitedClassTree = false;

        public UsesThisInstanceVisitor(Type instanceType) {
            this.instanceType = instanceType;
        }

        public void visitClass(ClassTree tree) {
            if (!this.visitedClassTree) {
                this.visitedClassTree = true;
                super.visitClass(tree);
            }
        }

        public void visitNewClass(NewClassTree tree) {
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            this.scan((Tree)tree.expression());
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol symbol = ((IdentifierTree)tree.methodSelect()).symbol();
                this.usesThisInstance |= symbol.isMethodSymbol() && !symbol.isStatic() && this.instanceType.isSubtypeOf(symbol.owner().type());
            }
            super.visitMethodInvocation(tree);
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.usesThisInstance |= "this".equals(tree.name());
        }
    }
}

