/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2447")
public class BooleanMethodReturnCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        SymbolMetadata metadata = methodTree.symbol().metadata();
        if (BooleanMethodReturnCheck.returnsBoolean(methodTree) && !metadata.nullabilityData().isNullable(SymbolMetadata.NullabilityLevel.PACKAGE, false, true)) {
            methodTree.accept((TreeVisitor)new ReturnStatementVisitor());
        }
    }

    private static boolean returnsBoolean(MethodTree methodTree) {
        return methodTree.returnType().symbolType().is("java.lang.Boolean");
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private ReturnStatementVisitor() {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                BooleanMethodReturnCheck.this.reportIssue((Tree)tree.expression(), "Null is returned but a \"Boolean\" is expected.");
            }
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

