/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4348")
public class IterableIteratorCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers ITERATOR = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Iterable"}).names(new String[]{"iterator"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ReturnThis returnThis = new ReturnThis();
        ClassTree classTree = (ClassTree)tree;
        Type classType = classTree.symbol().type();
        if (!classType.isSubtypeOf("java.util.Iterator") || !classType.isSubtypeOf("java.lang.Iterable")) {
            return;
        }
        classTree.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.METHOD})).filter(m -> ITERATOR.matches((MethodTree)m)).forEach(t -> t.accept((TreeVisitor)returnThis));
        if (!returnThis.issueLocations.isEmpty()) {
            this.reportIssue(returnThis.issueLocations.get(0), "Refactor this code so that the Iterator supports multiple traversal", returnThis.issueLocations.stream().skip(1L).map(t -> new JavaFileScannerContext.Location("", t)).collect(Collectors.toList()), null);
        }
    }

    private static class ReturnThis
    extends BaseTreeVisitor {
        private List<Tree> issueLocations = new ArrayList<Tree>();

        private ReturnThis() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            ExpressionTree returnedExpression = tree.expression();
            if (ExpressionUtils.isThis((ExpressionTree)returnedExpression)) {
                this.issueLocations.add((Tree)returnedExpression);
            }
            super.visitReturnStatement(tree);
        }
    }
}

