/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2230")
public class TransactionalMethodVisibilityCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        if (!method.symbol().isPublic() && TransactionalMethodVisibilityCheck.hasTransactionalAnnotation(method)) {
            this.reportIssue((Tree)method.simpleName(), "Make this method \"public\" or remove the \"@Transactional\" annotation");
        }
    }

    private static boolean hasTransactionalAnnotation(MethodTree method) {
        for (AnnotationTree annotation : method.modifiers().annotations()) {
            if (!annotation.symbolType().is("org.springframework.transaction.annotation.Transactional")) continue;
            return true;
        }
        return false;
    }
}

