/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4423")
public class WeakSSLContextCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> STRONG_PROTOCOLS = new HashSet<String>(Arrays.asList("TLSv1.2", "DTLSv1.2", "TLSv1.3", "DTLSv1.3"));
    private static final Set<String> STRONG_AFTER_JAVA_8 = new HashSet<String>(Arrays.asList("TLS", "DTLS"));
    private static final Set<String> WEAK_FOR_OK_HTTP = new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.1", "TLS_1_0", "TLS_1_1"));
    private static final MethodMatchers SSLCONTEXT_GETINSTANCE_MATCHER = MethodMatchers.create().ofTypes(new String[]{"javax.net.ssl.SSLContext"}).names(new String[]{"getInstance"}).withAnyParameters().build();
    private static final MethodMatchers OK_HTTP_TLS_VERSION = MethodMatchers.create().ofTypes(new String[]{"okhttp3.ConnectionSpec$Builder"}).names(new String[]{"tlsVersions"}).withAnyParameters().build();
    private boolean projectHasJava8OrHigher;

    public void setContext(JavaFileScannerContext context) {
        this.projectHasJava8OrHigher = context.getJavaVersion().asInt() >= 8;
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        List<Tree> unsecureVersions;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        Arguments arguments = mit.arguments();
        if (SSLCONTEXT_GETINSTANCE_MATCHER.matches(mit)) {
            ExpressionTree firstArgument = (ExpressionTree)arguments.get(0);
            firstArgument.asConstant(String.class).ifPresent(protocol -> {
                if (!this.isStrongProtocol((String)protocol)) {
                    this.reportIssue((Tree)firstArgument, "Change this code to use a stronger protocol.");
                }
            });
        } else if (OK_HTTP_TLS_VERSION.matches(mit) && !(unsecureVersions = WeakSSLContextCheck.getUnsecureVersionsInArguments(arguments)).isEmpty()) {
            List secondaries = unsecureVersions.stream().skip(1L).map(secondary -> new JavaFileScannerContext.Location("Other weak protocol.", secondary)).collect(Collectors.toList());
            this.reportIssue(unsecureVersions.get(0), "Change this code to use a stronger protocol.", secondaries, null);
        }
    }

    private boolean isStrongProtocol(String protocol) {
        return STRONG_PROTOCOLS.contains(protocol) || this.projectHasJava8OrHigher && STRONG_AFTER_JAVA_8.contains(protocol);
    }

    private static List<Tree> getUnsecureVersionsInArguments(Arguments arguments) {
        return arguments.stream().filter(WeakSSLContextCheck::isUnsecureVersion).collect(Collectors.toList());
    }

    private static boolean isUnsecureVersion(ExpressionTree expressionTree) {
        String argumentValue = null;
        Optional stringArgument = expressionTree.asConstant(String.class);
        if (stringArgument.isPresent()) {
            argumentValue = (String)stringArgument.get();
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            argumentValue = ((IdentifierTree)expressionTree).name();
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            argumentValue = ((MemberSelectExpressionTree)expressionTree).identifier().name();
        }
        return WEAK_FOR_OK_HTTP.contains(argumentValue);
    }
}

