/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class MethodTreeUtils {
    private MethodTreeUtils() {
    }

    public static boolean isMainMethod(MethodTree m) {
        return MethodTreeUtils.isPublic(m) && MethodTreeUtils.isStatic(m) && MethodTreeUtils.isNamed(m, "main") && MethodTreeUtils.returnsPrimitive(m, "void") && MethodTreeUtils.hasStringArrayParameter(m);
    }

    private static boolean hasStringArrayParameter(MethodTree m) {
        return m.parameters().size() == 1 && MethodTreeUtils.isParameterStringArray(m);
    }

    private static boolean isParameterStringArray(MethodTree m) {
        VariableTree variableTree = (VariableTree)m.parameters().get(0);
        boolean result = false;
        if (variableTree.type().is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)variableTree.type();
            result = arrayTypeTree.type().symbolType().isClass() && "String".equals(arrayTypeTree.type().symbolType().name());
        }
        return result;
    }

    public static boolean isEqualsMethod(MethodTree m) {
        boolean hasEqualsSignature = MethodTreeUtils.isNamed(m, "equals") && MethodTreeUtils.returnsPrimitive(m, "boolean") && MethodTreeUtils.hasObjectParameter(m);
        return MethodTreeUtils.isPublic(m) && !MethodTreeUtils.isStatic(m) && hasEqualsSignature;
    }

    private static boolean hasObjectParameter(MethodTree m) {
        return m.parameters().size() == 1 && ((VariableTree)m.parameters().get(0)).type().symbolType().is("java.lang.Object");
    }

    public static boolean isHashCodeMethod(MethodTree m) {
        boolean hasHashCodeSignature = MethodTreeUtils.isNamed(m, "hashCode") && m.parameters().isEmpty() && MethodTreeUtils.returnsInt(m);
        return MethodTreeUtils.isPublic(m) && !MethodTreeUtils.isStatic(m) && hasHashCodeSignature;
    }

    private static boolean isNamed(MethodTree m, String name) {
        return name.equals(m.simpleName().name());
    }

    private static boolean isStatic(MethodTree m) {
        return ModifiersUtils.hasModifier((ModifiersTree)m.modifiers(), (Modifier)Modifier.STATIC);
    }

    private static boolean isPublic(MethodTree m) {
        return ModifiersUtils.hasModifier((ModifiersTree)m.modifiers(), (Modifier)Modifier.PUBLIC);
    }

    private static boolean returnsInt(MethodTree m) {
        return MethodTreeUtils.returnsPrimitive(m, "int");
    }

    private static boolean returnsPrimitive(MethodTree m, String primitive) {
        TypeTree returnType = m.returnType();
        if (returnType == null) {
            return false;
        }
        return returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && primitive.equals(((PrimitiveTypeTree)returnType).keyword().text());
    }

    public static Optional<MethodInvocationTree> consecutiveMethodInvocation(Tree tree) {
        Tree memberSelectExpression = tree;
        Tree memberSelectExpressionParent = memberSelectExpression.parent();
        while (MethodTreeUtils.hasKind(memberSelectExpressionParent, Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            memberSelectExpression = memberSelectExpressionParent;
            memberSelectExpressionParent = memberSelectExpressionParent.parent();
        }
        if (MethodTreeUtils.hasKind(memberSelectExpressionParent, Tree.Kind.MEMBER_SELECT)) {
            Tree memberSelectParent;
            if (((MemberSelectExpressionTree)memberSelectExpressionParent).identifier() == memberSelectExpression) {
                memberSelectExpressionParent = memberSelectExpressionParent.parent();
            }
            if (MethodTreeUtils.hasKind(memberSelectParent = memberSelectExpressionParent.parent(), Tree.Kind.METHOD_INVOCATION)) {
                return Optional.of((MethodInvocationTree)memberSelectParent);
            }
        }
        return Optional.empty();
    }

    public static Optional<MethodInvocationTree> subsequentMethodInvocation(Tree tree, MethodMatchers methodMatchers) {
        return MethodTreeUtils.consecutiveMethodInvocation(tree).map(consecutiveMethod -> methodMatchers.matches(consecutiveMethod) ? consecutiveMethod : (MethodInvocationTree)MethodTreeUtils.subsequentMethodInvocation((Tree)consecutiveMethod, methodMatchers).orElse(null));
    }

    @VisibleForTesting
    static boolean hasKind(@Nullable Tree tree, Tree.Kind kind) {
        return tree != null && tree.kind() == kind;
    }

    public static class MethodInvocationCollector
    extends BaseTreeVisitor {
        private final List<Tree> invocationTree = new ArrayList<Tree>();
        private final Predicate<Symbol> collectPredicate;

        public MethodInvocationCollector(Predicate<Symbol> collectPredicate) {
            this.collectPredicate = collectPredicate;
        }

        public List<Tree> getInvocationTree() {
            return this.invocationTree;
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (this.collectPredicate.test(mit.symbol())) {
                this.invocationTree.add((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit));
            }
            super.visitMethodInvocation(mit);
        }

        public void visitNewClass(NewClassTree tree) {
            if (this.collectPredicate.test(tree.constructorSymbol())) {
                this.invocationTree.add((Tree)tree.identifier());
            }
            super.visitNewClass(tree);
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }
}

