/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.java.checks.helpers.IntersectAutomataChecker;
import org.sonar.java.checks.helpers.SubAutomaton;
import org.sonar.java.checks.helpers.SupersetAutomataChecker;
import org.sonar.java.regex.RegexCheck;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.EndOfLookaroundState;
import org.sonarsource.analyzer.commons.regex.ast.FinalState;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class RegexTreeHelper {
    private static final Pattern MARK_PATTERN = Pattern.compile("\\p{M}");

    private RegexTreeHelper() {
    }

    public static List<RegexCheck.RegexIssueLocation> getGraphemeInList(List<? extends RegexSyntaxElement> trees) {
        ArrayList<RegexCheck.RegexIssueLocation> result = new ArrayList<RegexCheck.RegexIssueLocation>();
        ArrayList<RegexSyntaxElement> codePoints = new ArrayList<RegexSyntaxElement>();
        for (RegexSyntaxElement regexSyntaxElement : trees) {
            CharacterTree currentCharacter;
            if (regexSyntaxElement instanceof CharacterTree && !(currentCharacter = (CharacterTree)regexSyntaxElement).isEscapeSequence()) {
                if (!RegexTreeHelper.isMark(currentCharacter)) {
                    RegexTreeHelper.addCurrentGrapheme(result, codePoints);
                    codePoints.clear();
                    codePoints.add((RegexSyntaxElement)currentCharacter);
                    continue;
                }
                if (codePoints.isEmpty()) continue;
                codePoints.add((RegexSyntaxElement)currentCharacter);
                continue;
            }
            RegexTreeHelper.addCurrentGrapheme(result, codePoints);
            codePoints.clear();
        }
        RegexTreeHelper.addCurrentGrapheme(result, codePoints);
        return result;
    }

    private static boolean isMark(CharacterTree currentChar) {
        return MARK_PATTERN.matcher(currentChar.characterAsString()).matches();
    }

    private static void addCurrentGrapheme(List<RegexCheck.RegexIssueLocation> result, List<RegexSyntaxElement> codePoints) {
        if (codePoints.size() > 1) {
            result.add(new RegexCheck.RegexIssueLocation(new ArrayList<RegexSyntaxElement>(codePoints), ""));
        }
    }

    public static boolean canReachWithoutConsumingInput(AutomatonState start, AutomatonState goal) {
        return RegexTreeHelper.canReachWithoutConsumingInput(start, goal, false, new HashSet<AutomatonState>());
    }

    public static boolean canReachWithoutConsumingInputOrGoingThroughBoundaries(AutomatonState start, AutomatonState goal) {
        return RegexTreeHelper.canReachWithoutConsumingInput(start, goal, true, new HashSet<AutomatonState>());
    }

    private static boolean canReachWithoutConsumingInput(AutomatonState start, AutomatonState goal, boolean stopAtBoundaries, Set<AutomatonState> visited) {
        if (start == goal) {
            return true;
        }
        if (visited.contains(start) || stopAtBoundaries && start instanceof BoundaryTree) {
            return false;
        }
        visited.add(start);
        for (AutomatonState successor : start.successors()) {
            AutomatonState.TransitionType transition = successor.incomingTransitionType();
            if ((!(successor instanceof EndOfLookaroundState) || successor != goal) && (transition != AutomatonState.TransitionType.EPSILON && transition != AutomatonState.TransitionType.NEGATION || !RegexTreeHelper.canReachWithoutConsumingInput(successor, goal, stopAtBoundaries, visited))) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer) {
        return new IntersectAutomataChecker(defaultAnswer).check(auto1, auto2);
    }

    public static boolean supersetOf(SubAutomaton auto1, SubAutomaton auto2, boolean defaultAnswer) {
        return new SupersetAutomataChecker(defaultAnswer).check(auto1, auto2);
    }

    public static boolean isAnchoredAtEnd(AutomatonState start) {
        return RegexTreeHelper.isAnchoredAtEnd(start, new HashSet<AutomatonState>());
    }

    private static boolean isAnchoredAtEnd(AutomatonState start, Set<AutomatonState> visited) {
        if (RegexTreeHelper.isEndBoundary(start)) {
            return true;
        }
        if (start instanceof FinalState || visited.contains(start)) {
            return false;
        }
        visited.add(start);
        for (AutomatonState successor : start.successors()) {
            if (RegexTreeHelper.isAnchoredAtEnd(successor, visited)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEndBoundary(AutomatonState state) {
        if (!(state instanceof BoundaryTree)) {
            return false;
        }
        switch (((BoundaryTree)state).type()) {
            case LINE_END: 
            case INPUT_END: 
            case INPUT_END_FINAL_TERMINATOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean onlyMatchesEmptySuffix(AutomatonState start) {
        return RegexTreeHelper.onlyMatchesEmptySuffix(start, new HashSet<AutomatonState>());
    }

    private static boolean onlyMatchesEmptySuffix(AutomatonState start, Set<AutomatonState> visited) {
        if (start instanceof FinalState || visited.contains(start)) {
            return true;
        }
        visited.add(start);
        if (start instanceof LookAroundTree) {
            return RegexTreeHelper.onlyMatchesEmptySuffix(start.continuation(), visited);
        }
        if (start.incomingTransitionType() != AutomatonState.TransitionType.EPSILON) {
            return false;
        }
        for (AutomatonState successor : start.successors()) {
            if (RegexTreeHelper.onlyMatchesEmptySuffix(successor, visited)) continue;
            return false;
        }
        return true;
    }
}

