/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5689")
public class DisclosingTechnologyFingerprintsCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure disclosing the fingerprinting of this web technology is safe here.";
    public static final String JAVA_LANG_STRING = "java.lang.String";
    private static final MethodMatchers SET_RESPONSE_HEADERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"javax.servlet.http.HttpServletResponse", "javax.servlet.http.HttpServletResponseWrapper", "org.apache.wicket.request.http.WebResponse", "org.apache.wicket.protocol.http.BufferedWebResponse", "org.apache.wicket.protocol.http.servlet.ServletWebResponse"}).names(new String[]{"addHeader", "setHeader"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.http.HttpHeaders"}).names(new String[]{"add", "set"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"org.rapidoid.http.Resp"}).names(new String[]{"header"}).addParametersMatcher(new String[]{"java.lang.String", "java.lang.String"}).build(), MethodMatchers.create().ofSubTypes(new String[]{"org.springframework.http.ResponseEntity$HeadersBuilder"}).names(new String[]{"header"}).withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
        if (SET_RESPONSE_HEADERS.matches(methodInvocationTree)) {
            ((ExpressionTree)methodInvocationTree.arguments().get(0)).asConstant(String.class).ifPresent(header -> {
                if (header.equalsIgnoreCase("server") || header.equalsIgnoreCase("x-powered-by")) {
                    this.reportIssue((Tree)methodInvocationTree, MESSAGE);
                }
            });
        }
    }
}

