/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3415")
public class AssertionArgumentOrderCheck
extends AbstractMethodDetection {
    private static final String ASSERT_ARRAY_EQUALS = "assertArrayEquals";
    private static final String ASSERT_EQUALS = "assertEquals";
    private static final String ASSERT_ITERABLE_EQUALS = "assertIterableEquals";
    private static final String ASSERT_LINES_MATCH = "assertLinesMatch";
    private static final String ASSERT_NOT_EQUALS = "assertNotEquals";
    private static final String ASSERT_NOT_SAME = "assertNotSame";
    private static final String ASSERT_SAME = "assertSame";
    private static final String EXPECTED_VALUE_ACTUAL_VALUE = "expected value, actual value";
    private static final String ACTUAL_VALUE_EXPECTED_VALUE = "actual value, expected value";
    private static final String ORG_JUNIT_ASSERT = "org.junit.Assert";
    private static final String ORG_TESTNG_ASSERT = "org.testng.Assert";
    private static final String ORG_JUNIT5_ASSERTIONS = "org.junit.jupiter.api.Assertions";
    private static final Tree.Kind[] LITERAL_KINDS = new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL};
    private static final String MESSAGE_TWO_LITERALS = "Change this assertion to not compare two literals.";
    private static final String MESSAGE_SWAP = "Swap these 2 arguments so they are in the correct order: %s.";
    private static final String MESSAGE_REPLACE = "Replace this literal with the actual expression you want to assert.";
    private static final MethodMatchers COLLECTION_CREATION_CALL = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Collections"}).name(name -> name.startsWith("singleton") || name.startsWith("empty")).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Arrays"}).names(new String[]{"asList"}).withAnyParameters().build()});

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{ORG_JUNIT_ASSERT}).names(new String[]{ASSERT_EQUALS, ASSERT_SAME, ASSERT_NOT_SAME}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{ORG_TESTNG_ASSERT}).names(new String[]{ASSERT_EQUALS, ASSERT_NOT_EQUALS, ASSERT_SAME, ASSERT_NOT_SAME}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{ORG_JUNIT5_ASSERTIONS}).names(new String[]{ASSERT_ARRAY_EQUALS, ASSERT_EQUALS, ASSERT_ITERABLE_EQUALS, ASSERT_LINES_MATCH, ASSERT_NOT_EQUALS, ASSERT_NOT_SAME, ASSERT_SAME}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"org.assertj.core.api.Assertions"}).names(new String[]{"assertThat", "assertThatObject"}).addParametersMatcher(new String[]{"*"}).build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Type ownerType = mit.symbol().owner().type();
        if (ownerType.is(ORG_JUNIT5_ASSERTIONS)) {
            this.checkArguments((ExpressionTree)mit.arguments().get(0), (ExpressionTree)mit.arguments().get(1), EXPECTED_VALUE_ACTUAL_VALUE);
        } else if (ownerType.is(ORG_JUNIT_ASSERT)) {
            ExpressionTree argToCheck = AssertionArgumentOrderCheck.getActualArgument(mit);
            this.checkArguments(AssertionArgumentOrderCheck.previousArg(argToCheck, mit), argToCheck, EXPECTED_VALUE_ACTUAL_VALUE);
        } else if (ownerType.is(ORG_TESTNG_ASSERT)) {
            this.checkArguments((ExpressionTree)mit.arguments().get(1), (ExpressionTree)mit.arguments().get(0), ACTUAL_VALUE_EXPECTED_VALUE);
        } else {
            Optional<ExpressionTree> expectedValue = AssertionArgumentOrderCheck.getExpectedValue(mit);
            ExpressionTree actualValue = (ExpressionTree)mit.arguments().get(0);
            if (expectedValue.isPresent()) {
                this.checkArguments(expectedValue.get(), actualValue, ACTUAL_VALUE_EXPECTED_VALUE);
            } else {
                this.checkArgument(actualValue);
            }
        }
    }

    private void checkArguments(ExpressionTree expectedArgument, ExpressionTree actualArgument, String correctOrder) {
        if (actualArgument.is(LITERAL_KINDS)) {
            if (expectedArgument.is(LITERAL_KINDS)) {
                this.newIssue(expectedArgument, actualArgument, MESSAGE_TWO_LITERALS, new Object[0]).report();
            } else {
                this.newIssue(expectedArgument, actualArgument, MESSAGE_SWAP, correctOrder).withQuickFix(() -> this.swap((Tree)expectedArgument, (Tree)actualArgument)).report();
            }
        } else if (AssertionArgumentOrderCheck.isExpectedPattern(actualArgument) && !AssertionArgumentOrderCheck.isExpectedPattern(expectedArgument)) {
            this.newIssue(expectedArgument, actualArgument, MESSAGE_SWAP, correctOrder).withQuickFix(() -> this.swap((Tree)expectedArgument, (Tree)actualArgument)).report();
        }
    }

    private JavaQuickFix swap(Tree x, Tree y) {
        String newX = QuickFixHelper.contentForTree(y, this.context);
        String newY = QuickFixHelper.contentForTree(x, this.context);
        return JavaQuickFix.newQuickFix((String)"Swap arguments").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)x, (String)newX)}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)y, (String)newY)}).build();
    }

    private void checkArgument(ExpressionTree actualArgument) {
        if (actualArgument.is(LITERAL_KINDS)) {
            this.newIssue(actualArgument, MESSAGE_REPLACE, new Object[0]).report();
        }
    }

    private InternalJavaIssueBuilder newIssue(ExpressionTree actualArgument, String message, Object ... args) {
        return QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)actualArgument).withMessage(message, args);
    }

    private InternalJavaIssueBuilder newIssue(ExpressionTree expectedArgument, ExpressionTree actualArgument, String message, Object ... args) {
        return this.newIssue(actualArgument, message, args).withSecondaries(new JavaFileScannerContext.Location[]{new JavaFileScannerContext.Location("Other argument to swap.", (Tree)expectedArgument)});
    }

    private static Optional<ExpressionTree> getExpectedValue(MethodInvocationTree mit) {
        return MethodTreeUtils.consecutiveMethodInvocation((Tree)mit).filter(secondInvocation -> {
            Tree parent = secondInvocation.parent();
            return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && secondInvocation.arguments().size() == 1;
        }).map(secondInvocation -> (ExpressionTree)secondInvocation.arguments().get(0));
    }

    private static boolean isNewArrayWithConstants(ExpressionTree actualArgument) {
        if (actualArgument.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            NewArrayTree newArrayTree = (NewArrayTree)actualArgument;
            return newArrayTree.initializers().stream().allMatch(AssertionArgumentOrderCheck::isConstant);
        }
        return false;
    }

    private static boolean isCollectionCreationWithConstants(ExpressionTree actualArgument) {
        if (actualArgument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)actualArgument;
            return COLLECTION_CREATION_CALL.matches(mit) && mit.arguments().stream().allMatch(AssertionArgumentOrderCheck::isConstant);
        }
        return false;
    }

    private static ExpressionTree previousArg(ExpressionTree argToCheck, MethodInvocationTree mit) {
        return (ExpressionTree)mit.arguments().get(mit.arguments().indexOf((Object)argToCheck) - 1);
    }

    private static ExpressionTree getActualArgument(MethodInvocationTree mit) {
        int arity = mit.arguments().size();
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(arity - 1);
        if (arity > 2 && (arity == 4 || ((Symbol.MethodSymbol)mit.symbol()).parameterTypes().stream().allMatch(AssertionArgumentOrderCheck::isDoubleOrFloat))) {
            arg = (ExpressionTree)mit.arguments().get(arity - 2);
        }
        return arg;
    }

    private static boolean isDoubleOrFloat(Type type) {
        return type.isPrimitive(Type.Primitives.DOUBLE) || type.isPrimitive(Type.Primitives.FLOAT);
    }

    private static boolean isExpectedPattern(ExpressionTree actualArgument) {
        return AssertionArgumentOrderCheck.isConstant((Tree)actualArgument) || AssertionArgumentOrderCheck.isNewArrayWithConstants(actualArgument) || AssertionArgumentOrderCheck.isCollectionCreationWithConstants(actualArgument);
    }

    private static boolean isConstant(Tree argToCheck) {
        return argToCheck.is(LITERAL_KINDS) || argToCheck.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && AssertionArgumentOrderCheck.isStaticFinal(((IdentifierTree)argToCheck).symbol()) || argToCheck.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && AssertionArgumentOrderCheck.isStaticFinal(((MemberSelectExpressionTree)argToCheck).identifier().symbol());
    }

    private static boolean isStaticFinal(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }
}

