/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5776")
public class ExpectedExceptionCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Consider using org.junit.Assert.assertThrows before other assertions.";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"org.junit.rules.ExpectedException"}).names(new String[]{"expect"}).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        BlockTree methodBody;
        MethodTree enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)mit);
        BlockTree blockTree = methodBody = enclosingMethod != null ? enclosingMethod.block() : null;
        if (methodBody == null) {
            return;
        }
        IdentifierTree methodIdentifier = ExpressionUtils.methodName((MethodInvocationTree)mit);
        int collectAfterLine = methodIdentifier.identifierToken().range().start().line();
        AssertionCollector assertionCollector = new AssertionCollector(collectAfterLine);
        methodBody.accept((TreeVisitor)assertionCollector);
        if (!assertionCollector.assertions.isEmpty()) {
            this.reportIssue((Tree)methodIdentifier, MESSAGE, assertionCollector.assertions, null);
        }
    }

    private static class AssertionCollector
    extends BaseTreeVisitor {
        private int collectAfterLine;
        private List<JavaFileScannerContext.Location> assertions = new ArrayList<JavaFileScannerContext.Location>();

        public AssertionCollector(int collectAfterLine) {
            this.collectAfterLine = collectAfterLine;
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (methodInvocation.firstToken().range().start().line() > this.collectAfterLine && UnitTestUtils.ASSERTIONS_METHOD_MATCHER.matches(methodInvocation)) {
                this.assertions.add(new JavaFileScannerContext.Location("Other assertion", (Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation)));
            }
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }
    }
}

