/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.tests.AbstractJUnit5NotCompliantModifierChecker;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5786")
public class JUnit5DefaultPackageClassAndMethodCheck
extends AbstractJUnit5NotCompliantModifierChecker {
    @Override
    protected boolean isNonCompliantModifier(Modifier modifier, boolean isMethod) {
        return modifier == Modifier.PUBLIC || modifier == Modifier.PROTECTED;
    }

    @Override
    protected void raiseIssueOnNonCompliantReturnType(MethodTree methodTree) {
    }

    @Override
    protected void raiseIssueOnNonCompliantModifier(ModifierKeywordTree modifier) {
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)modifier).withMessage("Remove this '%s' modifier.", new Object[]{modifier.keyword().text()}).withQuickFix(() -> JUnit5DefaultPackageClassAndMethodCheck.quickFix(modifier)).report();
    }

    private static JavaQuickFix quickFix(ModifierKeywordTree modifier) {
        return JavaQuickFix.newQuickFix((String)"Remove \"%s\" modifier", (Object[])new Object[]{modifier.keyword().text()}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)modifier, (boolean)true, (Tree)QuickFixHelper.nextToken((Tree)modifier), (boolean)false))}).build();
    }
}

