/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JspCodeVisitor;
import org.sonar.plugins.java.api.SourceMap;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="jspcheck", priority=Priority.MINOR, name="JspCodeCheck", description="JspCodeCheck")
public class JspCodeCheck
extends IssuableSubscriptionVisitor
implements JspCodeVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            this.visitClass((ClassTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.visitMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private void visitClass(ClassTree tree) {
        Path visitedClasses = this.context.getWorkingDirectory().toPath().resolve("visit.txt");
        Symbol.TypeSymbol symbol = tree.symbol();
        String name = symbol.type().fullyQualifiedName();
        String parent = symbol.superClass().isUnknown() ? "unknown" : symbol.superClass().fullyQualifiedName();
        try {
            Files.write(visitedClasses, String.format("%s extends %s%n", name, parent).getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void visitMethodInvocation(MethodInvocationTree tree) {
        if (this.isInvocation(tree, "index_jsp.java", 116) || this.isInvocation(tree, "test_005finclude_jsp.java", 124) || this.isInvocation(tree, "test_005finclude_jsp.java", 129)) {
            this.context.sourceMap().flatMap(sourceMap -> sourceMap.sourceMapLocationFor((Tree)tree)).ifPresent(this::writeToFile);
        }
    }

    private boolean isInvocation(MethodInvocationTree tree, String inputFile, int line) {
        return this.context.getInputFile().filename().equals(inputFile) && tree.firstToken().line() == line;
    }

    private void writeToFile(SourceMap.Location location) {
        try {
            Path path = this.context.getWorkingDirectory().toPath().resolve("JspCodeCheck.txt");
            String data = String.format("%s %d:%d%n", location.file().filename(), location.startLine(), location.endLine());
            Files.write(path, data.getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

