/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import org.sonar.runner.impl.ClassloadRules;

class IsolatedClassloader
extends URLClassLoader {
    private final ClassloadRules rules;

    IsolatedClassloader(ClassLoader parent, ClassloadRules rules) {
        super(new URL[0], parent);
        this.rules = rules;
    }

    void addFiles(List<File> files) {
        try {
            for (File file : files) {
                this.addURL(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Fail to create classloader", e);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                if (this.getParent() != null && this.rules.canLoad(name)) {
                    c = this.getParent().loadClass(name);
                } else {
                    ClassLoader systemClassLoader = IsolatedClassloader.getSystemClassLoader();
                    if (systemClassLoader.getParent() != null) {
                        systemClassLoader = systemClassLoader.getParent();
                    }
                    c = systemClassLoader.loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }
}

