/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import org.sonar.runner.cache.Logger;

public class IsolatedLauncherProxy
implements InvocationHandler {
    private final Object proxied;
    private final ClassLoader cl;
    private final Logger logger;

    private IsolatedLauncherProxy(ClassLoader cl, Object proxied, Logger logger) {
        this.cl = cl;
        this.proxied = proxied;
        this.logger = logger;
    }

    public static <T> T create(ClassLoader cl, Class<T> interfaceClass, String proxiedClassName, Logger logger) throws ReflectiveOperationException {
        Object proxied = IsolatedLauncherProxy.createProxiedObject(cl, proxiedClassName);
        Class<?> loadedInterfaceClass = cl.loadClass(interfaceClass.getName());
        return (T)IsolatedLauncherProxy.create(cl, proxied, loadedInterfaceClass, logger);
    }

    public static <T> T create(ClassLoader cl, Object proxied, Class<T> interfaceClass, Logger logger) {
        Class[] c = new Class[]{interfaceClass};
        return (T)Proxy.newProxyInstance(cl, c, (InvocationHandler)new IsolatedLauncherProxy(cl, proxied, logger));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
            this.logger.debug("Execution " + method.getName());
            Object object = method.invoke(this.proxied, args);
            return object;
        }
        catch (InvocationTargetException | UndeclaredThrowableException e) {
            throw IsolatedLauncherProxy.unwrapException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(initialContextClassLoader);
        }
    }

    private static Throwable unwrapException(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null && (cause instanceof UndeclaredThrowableException || cause instanceof InvocationTargetException)) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static Object createProxiedObject(ClassLoader cl, String proxiedClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> proxiedClass = cl.loadClass(proxiedClassName);
        return proxiedClass.newInstance();
    }
}

