/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import org.sonar.runner.impl.Tls12Java7SocketFactory;
import org.sonar.runner.okhttp.ConnectionSpec;
import org.sonar.runner.okhttp.OkHttpClient;

public class OkHttpClientFactory {
    static final int CONNECT_TIMEOUT_MILLISECONDS = 5000;
    static final int READ_TIMEOUT_MILLISECONDS = 60000;

    private OkHttpClientFactory() {
    }

    public static OkHttpClient create() {
        return OkHttpClientFactory.create(new JavaVersion());
    }

    static OkHttpClient create(JavaVersion javaVersion) {
        OkHttpClient httpClient = new OkHttpClient();
        httpClient.setConnectTimeout(5000L, TimeUnit.MILLISECONDS);
        httpClient.setReadTimeout(60000L, TimeUnit.MILLISECONDS);
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().supportsTlsExtensions(true).build();
        httpClient.setConnectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        if (javaVersion.isJava7()) {
            try {
                httpClient.setSslSocketFactory(new Tls12Java7SocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to init TLS context", e);
            }
        }
        return httpClient;
    }

    static class JavaVersion {
        JavaVersion() {
        }

        boolean isJava7() {
            return System.getProperty("java.version").startsWith("1.7.");
        }
    }
}

