/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class Tls12Java7SocketFactory
extends SSLSocketFactory {
    static final String[] TLS_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    private final SSLSocketFactory delegate;

    public Tls12Java7SocketFactory(SSLSocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(socket, host, port, autoClose);
        return Tls12Java7SocketFactory.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(host, port);
        return Tls12Java7SocketFactory.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(host, port, localAddress, localPort);
        return Tls12Java7SocketFactory.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(host, port);
        return Tls12Java7SocketFactory.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(host, port, localAddress, localPort);
        return Tls12Java7SocketFactory.overrideProtocol(underlyingSocket);
    }

    private static Socket overrideProtocol(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(TLS_PROTOCOLS);
        }
        return socket;
    }
}

