/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.http.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.http.rest.HttpsContextBuilder;
import org.sourcelab.http.rest.RestClient;
import org.sourcelab.http.rest.RestException;
import org.sourcelab.http.rest.RestResponse;
import org.sourcelab.http.rest.configuration.Configuration;
import org.sourcelab.http.rest.configuration.ProxyConfiguration;
import org.sourcelab.http.rest.exceptions.ConnectionException;
import org.sourcelab.http.rest.exceptions.ResultParsingException;
import org.sourcelab.http.rest.handlers.RestResponseHandler;
import org.sourcelab.http.rest.interceptor.HeaderRequestInterceptor;
import org.sourcelab.http.rest.interceptor.RequestContext;
import org.sourcelab.http.rest.interceptor.RequestInterceptor;
import org.sourcelab.http.rest.request.Request;
import org.sourcelab.http.rest.request.RequestHeader;
import org.sourcelab.http.rest.request.RequestMethod;
import org.sourcelab.http.rest.request.RequestParameter;
import org.sourcelab.http.rest.request.body.RequestBodyContent;
import org.sourcelab.http.rest.request.body.UrlEncodedFormBodyContent;

public class HttpClientRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientRestClient.class);
    private Configuration configuration;
    private CloseableHttpClient httpClient;
    private HttpClientContext httpClientContext;
    private final List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        if (configuration.getRequestHeaders() != null && !configuration.getRequestHeaders().isEmpty()) {
            this.requestInterceptors.add(new HeaderRequestInterceptor(configuration.getRequestHeaders()));
        }
        this.requestInterceptors.addAll(configuration.getRequestInterceptors());
        HttpsContextBuilder httpsContextBuilder = new HttpsContextBuilder(configuration);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setConnectionTimeToLive((long)configuration.getRequestTimeoutInSeconds(), TimeUnit.SECONDS).setSSLSocketFactory(httpsContextBuilder.createSslSocketFactory());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        this.httpClientContext = HttpClientContext.create();
        BasicAuthCache authCache = new BasicAuthCache();
        if (configuration.getProxyConfiguration() != null) {
            ProxyConfiguration proxyConfiguration = configuration.getProxyConfiguration();
            HttpHost proxyHost = new HttpHost(proxyConfiguration.getProxyHost(), proxyConfiguration.getProxyPort(), proxyConfiguration.getProxyScheme());
            if (proxyConfiguration.isProxyAuthenticationEnabled()) {
                credsProvider.setCredentials(new AuthScope(proxyConfiguration.getProxyHost(), proxyConfiguration.getProxyPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getProxyUsername(), proxyConfiguration.getProxyPassword()));
                authCache.put(new HttpHost(proxyConfiguration.getProxyHost(), proxyConfiguration.getProxyPort(), proxyConfiguration.getProxyScheme()), (AuthScheme)new BasicScheme());
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        if (configuration.getBasicAuthUsername() != null) {
            try {
                URL apiUrl = new URL(configuration.getApiHost());
                credsProvider.setCredentials(new AuthScope(apiUrl.getHost(), apiUrl.getPort()), (Credentials)new UsernamePasswordCredentials(configuration.getBasicAuthUsername(), configuration.getBasicAuthPassword()));
                authCache.put(new HttpHost(apiUrl.getHost(), apiUrl.getPort(), apiUrl.getProtocol()), (AuthScheme)new BasicScheme());
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        this.httpClientContext.setAuthCache((AuthCache)authCache);
        this.httpClientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.httpClient = clientBuilder.build();
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error closing: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.httpClient = null;
    }

    @Override
    public RestResponse submitRequest(Request request) throws RestException {
        String url = this.constructApiUrl(request.getApiEndpoint());
        RestResponseHandler responseHandler = new RestResponseHandler();
        try {
            switch (request.getRequestMethod()) {
                case GET: {
                    return this.submitGetRequest(url, request.getRequestBody(), responseHandler);
                }
                case POST: {
                    return this.submitPostRequest(url, request.getRequestBody(), responseHandler);
                }
                case PUT: {
                    return this.submitPutRequest(url, request.getRequestBody(), responseHandler);
                }
                case DELETE: {
                    return this.submitDeleteRequest(url, request.getRequestBody(), responseHandler);
                }
            }
            throw new IllegalArgumentException("Unknown Request Method: " + (Object)((Object)request.getRequestMethod()));
        }
        catch (IOException exception) {
            throw new RestException(exception.getMessage(), exception);
        }
    }

    private <T> T submitGetRequest(String url, RequestBodyContent requestBodyContent, ResponseHandler<T> responseHandler) throws IOException {
        RequestContext requestContext = new RequestContext(url, RequestMethod.GET);
        try {
            URIBuilder uriBuilder = new URIBuilder(url).setCharset(StandardCharsets.UTF_8);
            if (requestBodyContent instanceof UrlEncodedFormBodyContent) {
                List<RequestParameter> requestParameters = this.processRequestParameters(((UrlEncodedFormBodyContent)requestBodyContent).getRequestParameters(), requestContext);
                for (RequestParameter requestParameter : requestParameters) {
                    uriBuilder.setParameter(requestParameter.getName(), requestParameter.getValue());
                }
            }
            HttpGet get = new HttpGet(uriBuilder.build());
            this.buildHeaders((HttpRequestBase)get, requestContext);
            logger.debug("Executing request {}", (Object)get.getRequestLine());
            return (T)this.httpClient.execute((HttpUriRequest)get, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | URISyntaxException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPostRequest(String url, RequestBodyContent requestBodyContent, ResponseHandler<T> responseHandler) throws IOException {
        RequestContext requestContext = new RequestContext(url, RequestMethod.POST);
        try {
            HttpPost post = new HttpPost(url);
            this.buildHeaders((HttpRequestBase)post, requestContext);
            post.setEntity(this.buildEntity(requestBodyContent, requestContext));
            logger.debug("Executing request {} with {}", (Object)post.getRequestLine(), (Object)requestBodyContent);
            return (T)this.httpClient.execute((HttpUriRequest)post, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitPutRequest(String url, RequestBodyContent requestBodyContent, ResponseHandler<T> responseHandler) throws IOException {
        RequestContext requestContext = new RequestContext(url, RequestMethod.PUT);
        try {
            HttpPut put = new HttpPut(url);
            this.buildHeaders((HttpRequestBase)put, requestContext);
            put.setEntity(this.buildEntity(requestBodyContent, requestContext));
            logger.debug("Executing request {} with {}", (Object)put.getRequestLine(), (Object)requestBodyContent);
            return (T)this.httpClient.execute((HttpUriRequest)put, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private <T> T submitDeleteRequest(String url, Object requestBody, ResponseHandler<T> responseHandler) throws IOException {
        RequestContext requestContext = new RequestContext(url, RequestMethod.DELETE);
        try {
            HttpDelete delete = new HttpDelete(url);
            this.buildHeaders((HttpRequestBase)delete, requestContext);
            return (T)this.httpClient.execute((HttpUriRequest)delete, responseHandler, (HttpContext)this.httpClientContext);
        }
        catch (SocketException | SSLHandshakeException | ClientProtocolException connectionException) {
            throw new ConnectionException(connectionException.getMessage(), connectionException);
        }
        catch (IOException ioException) {
            throw new ResultParsingException(ioException.getMessage(), ioException);
        }
    }

    private String constructApiUrl(String endPoint) {
        return this.configuration.getApiHost() + endPoint;
    }

    private HttpEntity buildEntity(RequestBodyContent requestBodyContent, RequestContext requestContext) throws UnsupportedEncodingException {
        if (requestBodyContent instanceof UrlEncodedFormBodyContent) {
            List<RequestParameter> requestParameters = this.processRequestParameters(((UrlEncodedFormBodyContent)requestBodyContent).getRequestParameters(), requestContext);
            ArrayList params = new ArrayList();
            requestParameters.forEach(parameter -> params.add(new BasicNameValuePair(parameter.getName(), parameter.getValue())));
            return new UrlEncodedFormEntity(params);
        }
        return new StringEntity(requestBodyContent.toString());
    }

    private void buildHeaders(HttpRequestBase requestBase, RequestContext requestContext) {
        List<RequestHeader> headers = new ArrayList<RequestHeader>();
        for (RequestInterceptor requestInterceptor : this.requestInterceptors) {
            headers = requestInterceptor.modifyHeaders(headers, requestContext);
        }
        headers.stream().map(entry -> new BasicHeader(entry.getName(), entry.getValue())).forEach(arg_0 -> ((HttpRequestBase)requestBase).addHeader(arg_0));
    }

    private List<RequestParameter> processRequestParameters(List<RequestParameter> incomingParameters, RequestContext requestContext) {
        List<RequestParameter> requestParameters = new ArrayList<RequestParameter>(incomingParameters);
        for (RequestInterceptor requestInterceptor : this.requestInterceptors) {
            requestParameters = requestInterceptor.modifyRequestParameters(requestParameters, requestContext);
        }
        return requestParameters;
    }
}

