/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.http.rest;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.http.rest.NoopTrustManager;
import org.sourcelab.http.rest.configuration.Configuration;

class HttpsContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HttpsContextBuilder.class);
    private static final String[] sslProtocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private final Configuration configuration;

    public HttpsContextBuilder(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public LayeredConnectionSocketFactory createSslSocketFactory() {
        if (this.configuration.getIgnoreInvalidSslCertificates()) {
            logger.warn("Using insecure configuration, skipping server-side certificate validation checks.");
        }
        return new SSLConnectionSocketFactory(this.getSslContext(), this.getSslProtocols(), null, this.getHostnameVerifier());
    }

    HostnameVerifier getHostnameVerifier() {
        if (this.configuration.getIgnoreInvalidSslCertificates()) {
            return NoopHostnameVerifier.INSTANCE;
        }
        return SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    }

    SSLContext getSslContext() {
        try {
            SSLContext sslcontext = SSLContexts.createDefault();
            sslcontext.init(this.getKeyManagers(), this.getTrustManagers(), new SecureRandom());
            return sslcontext;
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    KeyManager[] getKeyManagers() {
        if (this.configuration.getKeyStoreFile() == null) {
            return new KeyManager[0];
        }
        try {
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            char[] password = this.configuration.getKeyStorePassword() == null ? new char[]{} : this.configuration.getKeyStorePassword().toCharArray();
            try (FileInputStream keyStoreFileInput = new FileInputStream(this.configuration.getKeyStoreFile());){
                keyStore.load(keyStoreFileInput, password);
            }
            keyFactory.init(keyStore, password);
            return keyFactory.getKeyManagers();
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException("Unable to find configured KeyStore file \"" + this.configuration.getKeyStoreFile() + "\"", exception);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    TrustManager[] getTrustManagers() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.configuration.getIgnoreInvalidSslCertificates()) {
                return new TrustManager[]{new NoopTrustManager()};
            }
            if (this.configuration.getTrustStoreFile() != null) {
                try (FileInputStream trustStoreFileInput = new FileInputStream(this.configuration.getTrustStoreFile());){
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    if (this.configuration.getTrustStorePassword() == null) {
                        keyStore.load(trustStoreFileInput, null);
                    } else {
                        keyStore.load(trustStoreFileInput, this.configuration.getTrustStorePassword().toCharArray());
                    }
                    trustManagerFactory.init(keyStore);
                }
                return trustManagerFactory.getTrustManagers();
            }
            trustManagerFactory.init((KeyStore)null);
            return trustManagerFactory.getTrustManagers();
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException("Unable to find configured TrustStore file \"" + this.configuration.getTrustStoreFile() + "\"", exception);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private String[] getSslProtocols() {
        return sslProtocols;
    }
}

