/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.http.rest.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sourcelab.http.rest.configuration.Configuration;
import org.sourcelab.http.rest.configuration.ProxyConfiguration;
import org.sourcelab.http.rest.interceptor.RequestInterceptor;
import org.sourcelab.http.rest.request.RequestHeader;

public class BasicConfiguration<SELF extends BasicConfiguration>
implements Configuration {
    private final String apiHost;
    private int requestTimeoutInSeconds = 300;
    private String basicAuthUsername = null;
    private String basicAuthPassword = null;
    private boolean ignoreInvalidSslCertificates = false;
    private File trustStoreFile = null;
    private String trustStorePassword = null;
    private File keyStoreFile = null;
    private String keyStorePassword = null;
    private ProxyConfiguration proxyConfiguration = null;
    private final List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
    private final List<RequestHeader> requestHeaders = new ArrayList<RequestHeader>();

    public BasicConfiguration(String apiHost) {
        if (apiHost == null) {
            throw new NullPointerException("apiHost parameter cannot be null!");
        }
        this.apiHost = apiHost.startsWith("http://") || apiHost.startsWith("https://") ? apiHost : "http://" + apiHost;
    }

    public SELF useBasicAuth(String username, String password) {
        this.basicAuthUsername = username;
        this.basicAuthPassword = password;
        return (SELF)this;
    }

    public SELF useProxy(ProxyConfiguration proxyConfig) {
        this.proxyConfiguration = proxyConfig;
        return (SELF)this;
    }

    public SELF useInsecureSslCertificates() {
        this.ignoreInvalidSslCertificates = true;
        return (SELF)this;
    }

    public SELF useTrustStore(File trustStoreFile, String password) {
        this.trustStoreFile = Objects.requireNonNull(trustStoreFile);
        this.trustStorePassword = password;
        return (SELF)this;
    }

    public SELF useKeyStore(File keyStoreFile, String password) {
        this.keyStoreFile = Objects.requireNonNull(keyStoreFile);
        this.keyStorePassword = password;
        return (SELF)this;
    }

    public SELF useRequestTimeoutInSeconds(int requestTimeoutInSeconds) {
        this.requestTimeoutInSeconds = requestTimeoutInSeconds;
        return (SELF)this;
    }

    public SELF useRequestInteceptor(RequestInterceptor requestInterceptor) {
        this.requestInterceptors.add(Objects.requireNonNull(requestInterceptor));
        return (SELF)this;
    }

    public SELF withRequestHeader(String name, String value) {
        this.requestHeaders.add(new RequestHeader(name, value));
        return (SELF)this;
    }

    @Override
    public String getApiHost() {
        return this.apiHost;
    }

    @Override
    public boolean getIgnoreInvalidSslCertificates() {
        return this.ignoreInvalidSslCertificates;
    }

    @Override
    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public int getRequestTimeoutInSeconds() {
        return this.requestTimeoutInSeconds;
    }

    @Override
    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    @Override
    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Override
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Override
    public List<RequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Override
    public List<RequestHeader> getRequestHeaders() {
        return Collections.unmodifiableList(this.requestHeaders);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration{").append("apiHost='").append(this.apiHost).append('\'').append(", requestTimeout='").append(this.requestTimeoutInSeconds).append('\'');
        if (this.getProxyConfiguration() != null) {
            stringBuilder.append(", proxy='").append(this.getProxyConfiguration().getProxyScheme()).append("://");
            if (this.getProxyConfiguration().getProxyUsername() != null) {
                stringBuilder.append(this.getProxyConfiguration().getProxyUsername()).append(':').append("XXXXXXX@");
            }
            stringBuilder.append(this.getProxyConfiguration().getProxyHost()).append(":").append(this.getProxyConfiguration().getProxyPort()).append('\'');
        }
        stringBuilder.append(", ignoreInvalidSslCertificates='").append(this.ignoreInvalidSslCertificates).append('\'');
        if (this.trustStoreFile != null) {
            stringBuilder.append(", sslTrustStoreFile='").append(this.trustStoreFile).append('\'');
            if (this.trustStorePassword != null) {
                stringBuilder.append(", sslTrustStorePassword='******'");
            }
        }
        if (this.basicAuthUsername != null) {
            stringBuilder.append(", basicAuthUsername='").append(this.basicAuthUsername).append('\'').append(", basicAuthPassword='******'");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

