/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.http.rest.configuration;

import java.util.Objects;

public class ProxyConfiguration {
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyScheme;
    private final String proxyUsername;
    private final String proxyPassword;

    public ProxyConfiguration(String proxyHost, int proxyPort, String proxyScheme, String proxyUsername, String proxyPassword) {
        this.proxyHost = Objects.requireNonNull(proxyHost);
        this.proxyPort = proxyPort;
        this.proxyScheme = Objects.requireNonNull(proxyScheme);
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public ProxyConfiguration(String proxyHost, int proxyPort, String proxyScheme) {
        this(proxyHost, proxyPort, proxyScheme, null, null);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public boolean isProxyAuthenticationEnabled() {
        return this.proxyUsername != null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String proxyHost;
        private int proxyPort;
        private String proxyScheme = "HTTP";
        private String proxyUsername;
        private String proxyPassword;

        private Builder() {
        }

        public Builder useProxy(String proxyHost, int proxyPort, String proxyScheme) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyScheme = proxyScheme;
            return this;
        }

        public Builder useProxyAuthentication(String proxyUsername, String proxyPassword) {
            this.proxyUsername = proxyUsername;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this.proxyHost, this.proxyPort, this.proxyScheme, this.proxyUsername, this.proxyPassword);
        }
    }
}

