/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.http.rest.exceptions;

import org.sourcelab.http.rest.exceptions.ResourceNotFoundException;
import org.sourcelab.http.rest.exceptions.UnauthorizedRequestException;

public class InvalidRequestException
extends RuntimeException {
    private final int errorCode;

    public InvalidRequestException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public InvalidRequestException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = -1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public static InvalidRequestException factory(String errorStr, int httpCode) {
        switch (httpCode) {
            case 401: {
                return new UnauthorizedRequestException(errorStr, httpCode);
            }
            case 404: {
                return new ResourceNotFoundException(errorStr);
            }
        }
        return new InvalidRequestException(errorStr, httpCode);
    }
}

