/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.http.rest.handlers;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourcelab.http.rest.RestResponse;

public final class RestResponseHandler
implements ResponseHandler<RestResponse> {
    private static final Logger logger = LoggerFactory.getLogger(RestResponseHandler.class);

    public RestResponse handleResponse(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            HttpEntity entity = response.getEntity();
            String responseStr = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            EntityUtils.consume((HttpEntity)entity);
            return new RestResponse(responseStr, statusCode);
        }
        catch (IOException exception) {
            logger.error("Failed to read entity: {}", (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }
}

