/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.SpdxDocument;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.DocumentInfoSheetV2d0;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public abstract class DocumentInfoSheet
extends AbstractSheet {
    static final int SPREADSHEET_VERSION_COL = 0;
    static final int DATA_ROW_NUM = 1;
    protected String version;

    public DocumentInfoSheet(Workbook workbook, String sheetName, String version, IModelStore modelStore, ModelCopyManager copyManager) throws SpreadsheetException {
        super(workbook, sheetName, modelStore, null, copyManager);
        this.documentUri = this.getNamespace();
        if (Objects.isNull(this.documentUri)) {
            throw new SpreadsheetException("Missing document URI in the document sheet");
        }
        Objects.requireNonNull(version, "Missing version");
        Objects.requireNonNull(modelStore, "Missing required model store");
        this.version = version;
    }

    public static void create(Workbook wb, String sheetName, String documentUri) {
        DocumentInfoSheetV2d0.create(wb, sheetName, documentUri);
    }

    public static DocumentInfoSheet openVersion(Workbook workbook, String originSheetName, String version, IModelStore modelStore, ModelCopyManager copyManager) throws SpreadsheetException {
        return new DocumentInfoSheetV2d0(workbook, originSheetName, version, modelStore, copyManager);
    }

    protected Row getDataRow() {
        return this.getDataRow(0);
    }

    protected Row getDataRow(int rowIndex) {
        while (this.firstRowNum + 1 + rowIndex > this.lastRowNum) {
            this.addRow();
        }
        Row dataRow = this.sheet.getRow(this.firstRowNum + 1 + rowIndex);
        if (dataRow == null) {
            dataRow = this.sheet.createRow(this.firstRowNum + 1 + rowIndex);
        }
        return dataRow;
    }

    protected Cell getOrCreateDataCell(int colNum) {
        Cell cell = this.getDataRow().getCell(colNum);
        if (cell == null) {
            cell = this.getDataRow().createCell(colNum);
        }
        return cell;
    }

    protected void setDataCellStringValue(int colNum, String value) {
        this.getOrCreateDataCell(colNum).setCellValue(value);
    }

    protected void setDataCellDateValue(int colNum, Date value) {
        Cell cell = this.getOrCreateDataCell(colNum);
        cell.setCellValue(value);
        cell.setCellStyle(this.dateStyle);
    }

    protected Date getDataCellDateValue(int colNum) {
        Cell cell = this.getDataRow().getCell(colNum);
        if (cell == null) {
            return null;
        }
        return cell.getDateCellValue();
    }

    protected String getDataCellStringValue(int colNum) {
        Cell cell = this.getDataRow().getCell(colNum);
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return Double.toString(cell.getNumericCellValue());
        }
        return cell.getStringCellValue();
    }

    public abstract void setSPDXVersion(String var1);

    public abstract void setCreatedBy(Collection<String> var1);

    public abstract void setDataLicense(String var1);

    public abstract void setAuthorComments(String var1);

    public abstract void setCreated(Date var1);

    public abstract Date getCreated();

    public abstract List<String> getCreatedBy();

    public abstract String getAuthorComments();

    public abstract String getSPDXVersion();

    public abstract String getDataLicense();

    public abstract String getDocumentComment();

    public abstract void setDocumentComment(String var1);

    public abstract String getLicenseListVersion();

    public abstract void setLicenseListVersion(String var1);

    public abstract String getNamespace();

    public abstract void addDocument(SpdxDocument var1) throws SpreadsheetException;

    public abstract String getSpdxId();

    public abstract void setSpdxId(String var1);

    public abstract String getDocumentName();

    public abstract void setDocumentName(String var1);

    public abstract Collection<String> getDocumentContents();

    public abstract void setDocumentDescribes(Collection<String> var1);

    public abstract Collection<ExternalDocumentRef> getExternalDocumentRefs() throws SpreadsheetException;

    public abstract void setExternalDocumentRefs(Collection<ExternalDocumentRef> var1) throws SpreadsheetException;
}

