/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class ExternalRefsSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger(ExternalRefsSheet.class);
    static final int PKG_ID_COL = 0;
    static final int REF_CATEGORY_COL = 1;
    static final int REF_TYPE_COL = 2;
    static final int REF_LOCATOR_COL = 3;
    static final int COMMENT_COL = 4;
    static final int USER_DEFINED_COLS = 5;
    static final int NUM_COLS = 6;
    static final boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    private static final String NO_REFERENCE_TYPE = "[No Reference Type]";

    static {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"Package ID", "Category", "Type", "Locator", "Comment", "User Defined ..."};
        COLUMN_WIDTHS = new int[]{25, 25, 40, 60, 40, 40};
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        LEFT_WRAP = blArray2;
        boolean[] blArray3 = new boolean[6];
        blArray3[0] = true;
        blArray3[1] = true;
        CENTER_NOWRAP = blArray3;
    }

    public ExternalRefsSheet(Workbook workbook, String sheetName, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, modelStore, documentUri, copyManager);
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for External Refs does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 5) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for External Refs worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.getFirstDataRow();
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying External Refs work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 6) {
            Cell cell = row.getCell(i);
            if (cell == null && REQUIRED[i]) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String externalRefsSheetName) {
        int sheetNum = wb.getSheetIndex(externalRefsSheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(externalRefsSheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    public void add(String packageId, ExternalRef externalRef) throws SpreadsheetException {
        block9: {
            Row row = this.addRow();
            if (packageId != null) {
                row.createCell(0).setCellValue(packageId);
            }
            try {
                Optional comment;
                if (externalRef == null) break block9;
                if (externalRef.getReferenceCategory() != null) {
                    row.createCell(1).setCellValue(externalRef.getReferenceCategory().toString());
                }
                try {
                    if (externalRef.getReferenceType() != null) {
                        row.createCell(2).setCellValue(this.refTypeToString(externalRef.getReferenceType()));
                    }
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error getting external reference type: " + e.getMessage());
                }
                if (externalRef.getReferenceLocator() != null) {
                    row.createCell(3).setCellValue(externalRef.getReferenceLocator());
                }
                if ((comment = externalRef.getComment()).isPresent()) {
                    row.createCell(4).setCellValue((String)comment.get());
                }
            }
            catch (InvalidSPDXAnalysisException ex) {
                throw new SpreadsheetException("Error getting externalRef from model store", ex);
            }
        }
    }

    protected String refTypeToString(ReferenceType referenceType) {
        String retval;
        if (referenceType == null) {
            return NO_REFERENCE_TYPE;
        }
        String referenceTypeUri = referenceType.getIndividualURI();
        if ("http://spdx.org/rdf/refeferences/MISSING".equals(referenceTypeUri)) {
            return NO_REFERENCE_TYPE;
        }
        try {
            retval = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(new URI(referenceTypeUri));
        }
        catch (InvalidSPDXAnalysisException e) {
            retval = null;
        }
        catch (URISyntaxException e) {
            retval = null;
        }
        if (retval == null && (retval = referenceTypeUri).startsWith(String.valueOf(this.documentUri) + "#")) {
            retval = retval.substring(this.documentUri.length() + 1);
        }
        return retval;
    }

    public List<ExternalRef> getExternalRefsForPkgid(String id) throws SpreadsheetException {
        ArrayList<ExternalRef> retval = new ArrayList<ExternalRef>();
        if (id == null || this.sheet == null) {
            return retval;
        }
        int i = this.getFirstDataRow();
        Row row = this.sheet.getRow(i++);
        while (row != null) {
            block10: {
                Cell pkgIdCell = row.getCell(0);
                try {
                    Cell commentCell;
                    Cell refLocatorCell;
                    Cell refTypeCell;
                    if (!Objects.nonNull(pkgIdCell) || !id.equals(pkgIdCell.getStringCellValue())) break block10;
                    ExternalRef er = new ExternalRef(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
                    Cell refCategoryCell = row.getCell(1);
                    if (refCategoryCell != null) {
                        try {
                            er.setReferenceCategory(ReferenceCategory.valueOf((String)refCategoryCell.getStringCellValue().trim().replace('-', '_')));
                        }
                        catch (Exception ex) {
                            throw new SpreadsheetException("Invalid reference category: " + refCategoryCell.getStringCellValue());
                        }
                    }
                    if ((refTypeCell = row.getCell(2)) != null) {
                        String refTypeStr = refTypeCell.getStringCellValue();
                        er.setReferenceType(this.stringToRefType(refTypeStr));
                    }
                    if ((refLocatorCell = row.getCell(3)) != null) {
                        er.setReferenceLocator(refLocatorCell.getStringCellValue());
                    }
                    if ((commentCell = row.getCell(4)) != null) {
                        er.setComment(commentCell.getStringCellValue());
                    }
                    retval.add(er);
                }
                catch (InvalidSPDXAnalysisException ex) {
                    throw new SpreadsheetException("Error creating ExternalRef", ex);
                }
            }
            row = this.sheet.getRow(i++);
        }
        return retval;
    }

    protected ReferenceType stringToRefType(String refTypeStr) {
        ReferenceType refType = null;
        if (refTypeStr != null) {
            refTypeStr = refTypeStr.trim();
            try {
                refType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(refTypeStr.trim());
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
            if (refType == null) {
                if (!refTypeStr.contains(":") && !refTypeStr.contains("/")) {
                    refTypeStr = String.valueOf(this.documentUri) + "#" + refTypeStr;
                }
                try {
                    refType = new ReferenceType(refTypeStr);
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.warn("SPDX Exception creating reference type", (Throwable)e);
                }
            }
        }
        return refType;
    }
}

