/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxPackage;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.PackageInfoSheetV2d0;
import org.spdx.spreadsheetstore.PackageInfoSheetV2d1;
import org.spdx.spreadsheetstore.PackageInfoSheetV2d2;
import org.spdx.spreadsheetstore.PackageInfoSheetV2d3;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public abstract class PackageInfoSheet
extends AbstractSheet {
    protected String version;

    public PackageInfoSheet(Workbook workbook, String sheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, modelStore, documentUri, copyManager);
        this.version = version;
    }

    public static void create(Workbook wb, String sheetName) {
        PackageInfoSheetV2d3.create(wb, sheetName);
    }

    public static PackageInfoSheet openVersion(Workbook workbook, String packageInfoSheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        if (version.compareTo("2.0.0") <= 0) {
            return new PackageInfoSheetV2d0(workbook, packageInfoSheetName, version, modelStore, documentUri, copyManager);
        }
        if (version.compareTo("2.1.0") <= 0) {
            return new PackageInfoSheetV2d1(workbook, packageInfoSheetName, version, modelStore, documentUri, copyManager);
        }
        if (version.compareTo("2.2.0") <= 0) {
            return new PackageInfoSheetV2d2(workbook, packageInfoSheetName, version, modelStore, documentUri, copyManager);
        }
        return new PackageInfoSheetV2d3(workbook, packageInfoSheetName, version, modelStore, documentUri, copyManager);
    }

    public abstract List<SpdxPackage> getPackages() throws SpreadsheetException;

    public abstract void add(SpdxPackage var1) throws InvalidSPDXAnalysisException;
}

