/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.PerFileSheetV2d0;
import org.spdx.spreadsheetstore.PerFileSheetV2d2;
import org.spdx.spreadsheetstore.PerFileSheetV2d3;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public abstract class PerFileSheet
extends AbstractSheet {
    protected String version;

    public PerFileSheet(Workbook workbook, String sheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, modelStore, documentUri, copyManager);
        this.version = version;
    }

    public static PerFileSheet openVersion(Workbook workbook, String perFileSheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        if (version.compareTo("2.1.0") <= 0) {
            return new PerFileSheetV2d0(workbook, perFileSheetName, version, modelStore, documentUri, copyManager);
        }
        if (version.compareTo("2.2.0") <= 0) {
            return new PerFileSheetV2d2(workbook, perFileSheetName, version, modelStore, documentUri, copyManager);
        }
        return new PerFileSheetV2d3(workbook, perFileSheetName, version, modelStore, documentUri, copyManager);
    }

    public abstract void add(SpdxFile var1, String var2) throws SpreadsheetException;

    public abstract SpdxFile getFileInfo(int var1) throws SpreadsheetException;

    public static void create(Workbook wb, String perFileSheetName) {
        PerFileSheetV2d2.create(wb, perFileSheetName);
    }

    public abstract List<String> getPackageIds(int var1);

    public static String fileTypesToString(Collection<FileType> fileTypeCollection) {
        if (fileTypeCollection == null || fileTypeCollection.size() == 0) {
            return "";
        }
        FileType[] fileTypes = fileTypeCollection.toArray(new FileType[fileTypeCollection.size()]);
        StringBuilder sb = new StringBuilder(fileTypes[0].toString());
        int i = 1;
        while (i < fileTypes.length) {
            sb.append(", ");
            String fileType = fileTypes[i].toString();
            sb.append(fileType);
            ++i;
        }
        return sb.toString();
    }

    public static Collection<FileType> parseFileTypeString(String typeStr) throws InvalidSPDXAnalysisException {
        ArrayList<FileType> retval = new ArrayList<FileType>();
        if (typeStr == null || typeStr.trim().isEmpty()) {
            return retval;
        }
        String[] stringArray = typeStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileTypeSub = stringArray[n2];
            String fileType = fileTypeSub.trim();
            if (fileType.endsWith(",")) {
                fileType = fileType.substring(0, fileType.length() - 1);
                fileType = fileType.trim();
            }
            try {
                retval.add(FileType.valueOf((String)fileType));
            }
            catch (Exception ex) {
                throw new InvalidSPDXAnalysisException("Unrecognized file type " + fileType);
            }
            ++n2;
        }
        return retval;
    }

    protected abstract String getFileId(int var1);
}

