/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.junit;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.specrunner.SRServices;
import org.specrunner.junit.JUnitUtils;
import org.specrunner.junit.ScenarioFrameworkMethod;
import org.specrunner.junit.SpecRunnerStatement;
import org.specrunner.listeners.INodeListener;
import org.specrunner.listeners.core.ScenarioFrameListener;
import org.specrunner.result.IResultSet;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.util.UtilString;
import org.specrunner.util.xom.UtilNode;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class SRRunnerSpringScenario
extends SpringJUnit4ClassRunner {
    private static final String FAKE = "toString";
    private int index;
    private List<INodeListener> listeners;

    public SRRunnerSpringScenario(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        try {
            LinkedList<FrameworkMethod> methods = new LinkedList<FrameworkMethod>();
            Method fake = this.getTestClass().getJavaClass().getMethod(FAKE, new Class[0]);
            methods.add(new FrameworkMethod(fake));
            File input = JUnitUtils.getFile((Class)this.getTestClass().getJavaClass());
            ISourceFactoryManager sfm = (ISourceFactoryManager)SRServices.get(ISourceFactoryManager.class);
            ISource source = sfm.newSource((Object)input.toString());
            Document document = source.getDocument();
            Nodes scenarios = document.query("//*[contains(@class,'scenario')]");
            this.listeners = new LinkedList<INodeListener>();
            HashSet<String> titles = new HashSet<String>();
            for (int i = 0; i < scenarios.size(); ++i) {
                String title = UtilNode.getCssNode((Node)scenarios.get(i), (String)"title").getValue();
                if (titles.contains(title = UtilString.camelCase((String)title, (boolean)true))) {
                    throw new RuntimeException("Scenario named '" + title + "' already exists. Scenarios must have different names.");
                }
                titles.add(title);
                methods.add((FrameworkMethod)new ScenarioFrameworkMethod(fake, title));
                this.listeners.add((INodeListener)new ScenarioFrameListener(title, JUnitUtils.getScenarioListener((Class)this.getTestClass().getJavaClass())));
            }
            return methods;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Description describeChild(FrameworkMethod method) {
        if (!method.getName().equalsIgnoreCase(FAKE)) {
            return super.describeChild(method);
        }
        if (method instanceof ScenarioFrameworkMethod) {
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)((ScenarioFrameworkMethod)method).getName());
        }
        return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.index++ == 0) {
            super.runChild(method, notifier);
        } else {
            Description description = Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)((ScenarioFrameworkMethod)method).getName());
            ScenarioFrameListener scenario = (ScenarioFrameListener)this.listeners.get(this.index - 2);
            IResultSet result = scenario.getResult();
            if (scenario.isPending()) {
                notifier.fireTestIgnored(description);
            } else if (result == null || !result.getStatus().isError()) {
                notifier.fireTestStarted(description);
                notifier.fireTestFinished(description);
            } else {
                notifier.fireTestFailure(new Failure(description, (Throwable)new Exception(result.asString())));
            }
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (!method.getName().equalsIgnoreCase(FAKE)) {
            return super.methodInvoker(method, test);
        }
        return new SpecRunnerStatement(this.getTestClass(), test, this.listeners);
    }
}

