/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.text;

import java.util.LinkedList;
import java.util.List;
import org.specrunner.source.text.Keywords;
import org.specrunner.source.text.NamedSentences;
import org.specrunner.source.text.Scenario;
import org.specrunner.source.text.Sentence;

public class Feature
extends NamedSentences {
    protected Keywords keywords;
    protected List<Sentence> background = new LinkedList<Sentence>();
    protected List<Sentence> finallys = new LinkedList<Sentence>();
    protected List<Scenario> scenarios = new LinkedList<Scenario>();

    public Feature(String name) {
        super(name);
    }

    public Keywords getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    public List<Sentence> getBackground() {
        return this.background;
    }

    public void setBackground(List<Sentence> background) {
        this.background = background;
    }

    public Feature addBackground(Sentence background) {
        this.background.add(background);
        return this;
    }

    public List<Sentence> getFinallys() {
        return this.finallys;
    }

    public void setFinallys(List<Sentence> finallys) {
        this.finallys = finallys;
    }

    public Feature addFinallys(Sentence finallys) {
        this.finallys.add(finallys);
        return this;
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(List<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public Feature add(Scenario scenario) {
        this.scenarios.add(scenario);
        scenario.setParent(this);
        return this;
    }

    @Override
    public String validate() {
        StringBuilder sb = new StringBuilder();
        if (this.name == null || this.name.isEmpty()) {
            sb.append("\nFeature name not found.");
        }
        for (Scenario s : this.scenarios) {
            sb.append(s.validate());
        }
        return sb.toString();
    }
}

