/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.text;

import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.data.PluginMap;
import org.specrunner.plugins.core.flow.PluginIterator;
import org.specrunner.plugins.core.language.PluginSentence;
import org.specrunner.plugins.core.macro.PluginCall;
import org.specrunner.plugins.core.macro.PluginMacro;
import org.specrunner.source.text.DataTable;
import org.specrunner.source.text.Feature;
import org.specrunner.source.text.Keywords;
import org.specrunner.source.text.NamedSentences;
import org.specrunner.source.text.Scenario;
import org.specrunner.source.text.ScenarioOutline;
import org.specrunner.source.text.Sentence;
import org.specrunner.util.expression.UtilExpression;
import org.specrunner.util.string.UtilString;
import org.specrunner.util.xom.IPresenter;
import org.specrunner.util.xom.UtilNode;

public class FeaturePresenter
implements IPresenter {
    public void initialize() {
    }

    public Node asNode(Object obj, Object ... args) {
        if (!(obj instanceof Feature)) {
            throw new IllegalArgumentException("Invalid source instance:" + obj + " of type " + (obj != null ? obj.getClass() : null));
        }
        Feature feature = (Feature)obj;
        Keywords keywords = feature.getKeywords();
        if (keywords == null) {
            throw new IllegalArgumentException("Feature keywords not set.");
        }
        return this.dumpFeature(new Element("div"), keywords, feature);
    }

    protected Node dumpFeature(Element root, Keywords words, Feature feature) {
        this.dumpDescription(root, words.getFeature(), feature, "h1");
        this.dumpList(root, feature.getSentences());
        List<Scenario> scenarios = feature.getScenarios();
        if (!scenarios.isEmpty()) {
            for (Scenario s : scenarios) {
                this.dumpScenario(root, words, s);
            }
        }
        return root;
    }

    protected void dumpDescription(Element root, String keyword, NamedSentences description, String tag) {
        Element e = new Element(tag);
        UtilNode.appendCss((Node)e, (String)"title");
        root.appendChild((Node)e);
        e.appendChild(keyword + (description != null ? description.getName() : ""));
    }

    protected void dumpList(Element root, List<Sentence> list) {
        if (list != null && !list.isEmpty()) {
            Element quote = new Element("blockquote");
            root.appendChild((Node)quote);
            for (Sentence s : list) {
                quote.appendChild(s.getText());
                quote.appendChild((Node)new Element("br"));
            }
        }
    }

    protected void dumpScenario(Element root, Keywords words, Scenario scenario) {
        Element divScenario = new Element("div");
        UtilNode.appendCss((Node)divScenario, (String)"scenario");
        root.appendChild((Node)divScenario);
        if (scenario instanceof ScenarioOutline) {
            this.dumpMultiScenario(divScenario, words, (ScenarioOutline)scenario);
        } else {
            this.dumpSingleScenario(divScenario, words, scenario);
        }
    }

    protected void dumpMultiScenario(Element root, Keywords words, ScenarioOutline scenario) {
        this.dumpExamples(root, words, scenario, this.dumpMacro(root, words, scenario));
    }

    protected String dumpMacro(Element root, Keywords words, Scenario scenario) {
        String alias;
        Element macro = new Element("div");
        root.appendChild((Node)macro);
        try {
            alias = ((IPluginFactory)SRServices.get(IPluginFactory.class)).getAlias(PluginMacro.class);
        }
        catch (PluginException e) {
            alias = "macro";
        }
        macro.addAttribute(new Attribute("class", alias));
        String name = UtilString.getNormalizer().camelCase(scenario.getName());
        macro.addAttribute(new Attribute("name", name));
        this.dumpDescription(macro, words.getScenarioOutline(), scenario, "h2");
        this.dumpExecutableList(macro, scenario.getParent().getBackground(), true);
        this.dumpExecutableList(macro, scenario.getSentences(), true);
        this.dumpExecutableList(macro, scenario.getParent().getFinallys(), true);
        return name;
    }

    protected void dumpExecutableList(Element root, List<Sentence> list, boolean replace) {
        String alias;
        Element quote = new Element("blockquote");
        try {
            alias = ((IPluginFactory)SRServices.get(IPluginFactory.class)).getAlias(PluginSentence.class);
        }
        catch (PluginException e) {
            alias = "sentence";
        }
        for (Sentence s : list) {
            Element sentence = new Element("span");
            sentence.appendChild(replace ? this.normalize(s.getText()) : s.getText());
            sentence.addAttribute(new Attribute("class", alias));
            quote.appendChild((Node)sentence);
            quote.appendChild((Node)new Element("br"));
            if (s.hasData()) {
                Element arg = new Element("arg");
                arg.addAttribute(new Attribute("value", "$NODE"));
                this.dumpTable(arg, s.getData(), false);
                sentence.appendChild((Node)arg);
            }
            if (!s.hasMessage()) continue;
            Element message = new Element("arg");
            message.appendChild(replace ? this.normalize(s.getMessage()) : s.getMessage());
            sentence.appendChild((Node)message);
        }
        if (quote.getChildCount() > 0) {
            root.appendChild((Node)quote);
        }
    }

    protected String normalize(String text) {
        return text.replace("<", "#{").replace(">", "}");
    }

    protected void dumpExamples(Element root, Keywords words, ScenarioOutline outline, String name) {
        Element examples = new Element("div");
        root.appendChild((Node)examples);
        this.dumpDescription(examples, words.getExamples(), null, "h3");
        this.dumpMap(examples, outline);
        this.dumpIterator(examples, name);
    }

    protected void dumpMap(Element root, ScenarioOutline outline) {
        this.dumpTable(root, outline.getTable(), true);
    }

    protected void dumpTable(Element root, DataTable data, boolean example) {
        Element quote = new Element("blockquote");
        root.appendChild((Node)quote);
        Element table = new Element("table");
        if (example) {
            String alias;
            try {
                alias = ((IPluginFactory)SRServices.get(IPluginFactory.class)).getAlias(PluginMap.class);
            }
            catch (PluginException e1) {
                alias = "map";
            }
            table.addAttribute(new Attribute("class", alias));
        }
        table.addAttribute(new Attribute("name", "examples"));
        table.addAttribute(new Attribute("scope", "div"));
        quote.appendChild((Node)table);
        Element tr = new Element("tr");
        table.appendChild((Node)tr);
        for (String string : data.getNames()) {
            Element td = new Element("th");
            td.appendChild(string);
            tr.appendChild((Node)td);
        }
        for (List list : data.getExamples()) {
            tr = new Element("tr");
            for (String str : list) {
                Element td = new Element("td");
                td.appendChild(str);
                tr.appendChild((Node)td);
            }
            table.appendChild((Node)tr);
        }
    }

    protected void dumpIterator(Element root, String name) {
        String alias;
        Element iterator = new Element("span");
        try {
            alias = ((IPluginFactory)SRServices.get(IPluginFactory.class)).getAlias(PluginIterator.class);
        }
        catch (PluginException e) {
            alias = "iterator";
        }
        iterator.addAttribute(new Attribute("class", alias));
        iterator.addAttribute(new Attribute("name", "examples"));
        root.appendChild((Node)iterator);
        this.dumpCall(iterator, name);
    }

    protected void dumpCall(Element root, String name) {
        String alias;
        Element h4 = new Element("h4");
        h4.appendChild("Example " + UtilExpression.asExpression((String)"index+1") + ":");
        root.appendChild((Node)h4);
        Element quo = new Element("blockquote");
        root.appendChild((Node)quo);
        Element call = new Element("p");
        try {
            alias = ((IPluginFactory)SRServices.get(IPluginFactory.class)).getAlias(PluginCall.class);
        }
        catch (PluginException e) {
            alias = "call";
        }
        call.addAttribute(new Attribute("class", alias));
        call.addAttribute(new Attribute("name", name));
        quo.appendChild((Node)call);
    }

    public void dumpSingleScenario(Element root, Keywords words, Scenario scenario) {
        this.dumpDescription(root, words.getScenario(), scenario, "h2");
        this.dumpExecutableList(root, scenario.getParent().getBackground(), false);
        this.dumpExecutableList(root, scenario.getSentences(), false);
        this.dumpExecutableList(root, scenario.getParent().getFinallys(), false);
    }

    public String asString(Object obj, Object ... args) {
        if (!(obj instanceof Feature)) {
            return null;
        }
        return null;
    }
}

