/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.specrunner.SRServices;
import org.specrunner.source.text.DataTable;
import org.specrunner.source.text.Feature;
import org.specrunner.source.text.IFeatureReader;
import org.specrunner.source.text.Keywords;
import org.specrunner.source.text.NamedSentences;
import org.specrunner.source.text.Scenario;
import org.specrunner.source.text.ScenarioOutline;
import org.specrunner.source.text.Sentence;
import org.specrunner.source.text.SourceFactoryText;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public class FeatureReaderImpl
implements IFeatureReader {
    private static final int TEN = 10;
    protected static ICache<String, Keywords> cacheKeywords = ((ICacheFactory)SRServices.get(ICacheFactory.class)).newCache(SourceFactoryText.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature load(InputStream in, String encoding) throws IOException {
        InputStreamReader isr = null;
        BufferedReader bin = null;
        try {
            isr = new InputStreamReader(in, Charset.forName(encoding));
            bin = new BufferedReader(isr);
            String input = bin.readLine();
            while (input != null && (input = input.trim()).isEmpty()) {
                input = bin.readLine();
            }
            String lang = null;
            boolean found = false;
            if (input != null && input.toLowerCase().contains("language:")) {
                lang = input.substring(input.lastIndexOf(58) + 1, input.length()).trim();
                found = true;
            }
            if (!found) {
                lang = "en";
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Language " + (found ? "not found" : "found") + " setting to " + lang);
            }
            Keywords keywords = null;
            ICache<String, Keywords> iCache = cacheKeywords;
            synchronized (iCache) {
                keywords = (Keywords)cacheKeywords.get((Object)lang);
                if (keywords == null) {
                    keywords = new Keywords(ResourceBundle.getBundle("sr_gherkin", new Locale(lang)));
                    cacheKeywords.put((Object)lang, (Object)keywords);
                }
            }
            Feature feature = new Feature("");
            feature.setKeywords(keywords);
            if (lang != null) {
                this.readKeyword(bin, found ? lang : input, keywords.getFeature(), feature);
                this.readFeatureDescription(bin, bin.readLine(), keywords, feature);
            }
            Feature feature2 = feature;
            return feature2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
    }

    protected void readKeyword(BufferedReader reader, String line, String keyword, NamedSentences named) throws IOException {
        while (line != null && !(line = line.trim()).startsWith(keyword)) {
            line = reader.readLine();
        }
        if (line != null) {
            named.setName(line.substring(keyword.length()));
        }
    }

    protected void readFeatureDescription(BufferedReader reader, String line, Keywords words, Feature feature) throws IOException {
        line = this.readNextGroup(reader, line, feature.getSentences());
        while (line != null) {
            Scenario sc;
            if ((line = line.trim()).startsWith(words.getBackground())) {
                line = this.readNextGroup(reader, reader.readLine(), feature.getBackground());
                continue;
            }
            if (line.startsWith(words.getFinally())) {
                line = this.readNextGroup(reader, reader.readLine(), feature.getFinallys());
                continue;
            }
            if (line.startsWith(words.getScenario())) {
                sc = new Scenario("");
                this.readKeyword(reader, line, words.getScenario(), sc);
                line = this.readNextGroup(reader, reader.readLine(), sc.getSentences());
                feature.add(sc);
                continue;
            }
            if (line.startsWith(words.getScenarioOutline())) {
                sc = new ScenarioOutline("");
                this.readKeyword(reader, line, words.getScenarioOutline(), sc);
                line = this.readNextGroup(reader, reader.readLine(), sc.getSentences());
                feature.add(sc);
                if (line == null || !(line = line.trim()).startsWith(words.getExamples())) continue;
                this.readExamples(reader, reader.readLine(), (ScenarioOutline)sc);
                continue;
            }
            line = reader.readLine();
        }
    }

    protected String readNextGroup(BufferedReader reader, String line, List<Sentence> group) throws IOException {
        boolean extra = false;
        while (line != null && !(line = line.trim()).isEmpty()) {
            Sentence tmp = new Sentence(line);
            group.add(tmp);
            line = reader.readLine();
            if (!tmp.getText().endsWith(":")) continue;
            line = this.readTableOrMessage(reader, line, tmp);
            extra = true;
        }
        while (!extra && line != null && (line = line.trim()).isEmpty()) {
            line = reader.readLine();
        }
        return line;
    }

    private String readTableOrMessage(BufferedReader reader, String line, Sentence sentence) throws IOException {
        if (line != null) {
            line = line.trim();
            String lineMark = "\"\"\"";
            if (line.startsWith("|")) {
                DataTable table = new DataTable();
                line = this.readTable(reader, line, table);
                sentence.setData(table);
            } else if (line.equals(lineMark)) {
                StringBuilder msg = new StringBuilder();
                line = reader.readLine();
                while (line != null && !lineMark.equals(line.trim())) {
                    msg.append(line + "\n");
                    line = reader.readLine();
                }
                line = reader.readLine();
                sentence.setMessage(msg.toString());
            } else {
                throw new IOException("After sentences ending with ':' data tables or messages are expected.");
            }
        }
        return line;
    }

    protected void readExamples(BufferedReader reader, String line, ScenarioOutline outline) throws IOException {
        if (line != null) {
            this.readTable(reader, line, outline.getTable());
        }
    }

    protected String readTable(BufferedReader reader, String line, DataTable table) throws IOException {
        StringTokenizer st = new StringTokenizer(line.trim(), "|");
        while (st.hasMoreTokens()) {
            table.add(st.nextToken().trim());
        }
        line = reader.readLine();
        while (line != null && !(line = line.trim()).isEmpty() && line.startsWith("|")) {
            LinkedList<String> args = new LinkedList<String>();
            st = new StringTokenizer(line, "|");
            while (st.hasMoreTokens()) {
                args.add(st.nextToken().trim());
            }
            table.add(args);
            line = reader.readLine();
        }
        return line;
    }

    static {
        cacheKeywords.setSize(10L);
    }
}

