/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.text;

import org.specrunner.source.text.DataTable;
import org.specrunner.source.text.IValidable;

public class Sentence
implements IValidable {
    protected String text;
    protected DataTable data;
    protected String message;

    public Sentence(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public DataTable getData() {
        return this.data;
    }

    public void setData(DataTable data) {
        this.data = data;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String validate() {
        StringBuilder sb = new StringBuilder();
        if (this.text == null) {
            sb.append("Invalid sentence with null text.\n");
        }
        if (this.text != null && this.text.endsWith(":") && !this.hasData() && !this.hasMessage()) {
            sb.append("Sentences terminated by ':' expect data table or message values.");
        }
        if (this.hasData()) {
            sb.append(this.data.validate());
        }
        return sb.toString();
    }
}

