/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.source.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.specrunner.SRServices;
import org.specrunner.source.SourceException;
import org.specrunner.source.core.AbstractSourceFactory;
import org.specrunner.source.text.Feature;
import org.specrunner.source.text.FeatureReaderImpl;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.IPresenter;
import org.specrunner.util.xom.IPresenterManager;

public class SourceFactoryText
extends AbstractSourceFactory {
    protected static final int GAP = 4;

    protected Document fromTarget(URI uri, String target, String encoding) throws SourceException {
        Element root = new Element("html");
        Document doc = new Document(root);
        Element head = new Element("head");
        root.appendChild((Node)head);
        Element body = new Element("body");
        root.appendChild((Node)body);
        InputStream in = null;
        try {
            if (this.isFile(uri, target)) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Source from file:" + target);
                }
                in = new FileInputStream(new File(target));
            } else {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Source from URI:" + uri);
                }
                in = uri.toURL().openStream();
            }
            FeatureReaderImpl sr = new FeatureReaderImpl();
            Feature feature = sr.load(in, encoding);
            String error = feature.validate();
            if (!error.isEmpty()) {
                throw new SourceException("Invalid feature file(" + target + "):" + error);
            }
            IPresenter presenter = (IPresenter)((IPresenterManager)SRServices.get(IPresenterManager.class)).get((Object)feature.getClass().getName());
            Node node = presenter.asNode((Object)feature, new Object[0]);
            body.appendChild(node);
            if (UtilLog.LOG.isTraceEnabled()) {
                Serializer dumper = new Serializer((OutputStream)System.out);
                dumper.setIndent(4);
                dumper.write(doc);
            }
        }
        catch (Exception e) {
            throw new SourceException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new SourceException((Throwable)e);
                }
            }
        }
        return doc;
    }
}

