/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.ISRMapping;
import org.specrunner.ISpecRunner;
import org.specrunner.ISpecRunnerFactory;
import org.specrunner.ISpecRunnerFactoryPlugin;
import org.specrunner.ISpecRunnerPlugin;
import org.specrunner.SpecRunnerException;
import org.specrunner.comparators.IComparatorManager;
import org.specrunner.converters.IConverterManager;
import org.specrunner.core.SpecRunnerPipelineUtils;
import org.specrunner.expressions.IExpressionFactory;
import org.specrunner.features.IFeatureManager;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IChannelFactory;
import org.specrunner.pipeline.IPipeline;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.util.UtilLog;

public final class SRServices {
    private static ThreadLocal<SRServices> instance = new ThreadLocal();
    private final Map<Class<?>, Object> servicePool = new HashMap();
    private ISRMapping mapping;
    private String threadName;

    private SRServices() {
        String str = System.getProperty("srmapping", "org.specrunner.core.SRMappingDefault");
        try {
            this.mapping = (ISRMapping)Class.forName(str).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getDefault(Class<T> type) {
        SRServices result = null;
        result = type == SRServices.class ? this : this.mapping.getDefault(type);
        return type.cast(result);
    }

    public <T> void bind(Class<T> clazz, T instance) {
        this.servicePool.put(clazz, instance);
    }

    public <T> T lookup(Class<T> clazz) {
        Object obj = this.servicePool.get(clazz);
        if (obj == null && (obj = this.getDefault(clazz)) != null) {
            this.bind(clazz, obj);
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object of type '" + clazz + "' not found in pool of services.");
        }
        return (T)obj;
    }

    public Map<Class<?>, Object> getServices() {
        return this.servicePool;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public static <T> T get(Class<T> clazz) {
        return SRServices.get().lookup(clazz);
    }

    public static SRServices get() {
        if (instance.get() == null) {
            SRServices service = new SRServices();
            service.threadName = Thread.currentThread().getName();
            Runtime.getRuntime().addShutdownHook(new ShutDown(service));
            instance.set(service);
        }
        return instance.get();
    }

    public static IFeatureManager getFeatureManager() {
        return SRServices.get(IFeatureManager.class);
    }

    public static IConverterManager getConverterManager() {
        return SRServices.get(IConverterManager.class);
    }

    public static IComparatorManager getComparatorManager() {
        return SRServices.get(IComparatorManager.class);
    }

    public static IExpressionFactory getExpressionFactory() {
        return SRServices.get(IExpressionFactory.class);
    }

    public static ISpecRunner getSpecRunner() throws SpecRunnerException {
        return SRServices.get(ISpecRunnerFactory.class).newRunner();
    }

    public static ISpecRunnerPlugin getSpecRunnerPlugin() throws SpecRunnerException {
        return SRServices.get(ISpecRunnerFactoryPlugin.class).newRunner();
    }

    public static void release() {
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Release programmatic call.");
        }
        SRServices.release(instance.get());
    }

    private static void release(SRServices service) {
        block2: {
            try {
                IChannel channel = service.lookup(IChannelFactory.class).newChannel();
                channel.add("shutdown", service);
                IPipeline pipeline = SpecRunnerPipelineUtils.getPipeline(service, "specrunner_shutdown.xml");
                pipeline.process(channel);
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block2;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class ShutDown
    extends Thread {
        public static final String SHUTDOWN = "shutdown";
        private final SRServices shutdown;

        public ShutDown(SRServices shutdown) {
            this.shutdown = shutdown;
        }

        @Override
        public void run() {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Release shutdown call.");
            }
            SRServices.release(this.shutdown);
        }

        public static SRServices recover(IChannel channel) throws PipelineException {
            return channel.get(SHUTDOWN, SRServices.class);
        }
    }
}

