/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.annotator.core;

import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.annotator.AnnotatorException;
import org.specrunner.annotator.IAnnotator;
import org.specrunner.context.IBlock;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;

public class AnnotatorLink
implements IAnnotator {
    @Override
    public void annotate(IResultSet result) throws AnnotatorException {
        int stackIndex = 1;
        for (IResult r : result) {
            IBlock block = r.getBlock();
            if (!block.hasNode() || !r.hasFailure()) continue;
            this.addLinkToError(block.getNode(), stackIndex++);
        }
    }

    protected void addLinkToError(Node node, int errorIndex) {
        if (node instanceof ParentNode) {
            ParentNode ele = (ParentNode)node;
            if (ele instanceof Document) {
                ele = ((Document)ele).getRootElement();
            }
            Element child = new Element("a");
            child.addAttribute(new Attribute("name", "" + errorIndex));
            ele.insertChild((Node)child, 0);
        }
    }
}

