/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.annotator.core;

import java.io.IOException;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.annotator.AnnotatorException;
import org.specrunner.annotator.IAnnotator;
import org.specrunner.context.IBlock;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.util.ExceptionUtil;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.IPresentation;

public class AnnotatorStacktrace
implements IAnnotator {
    @Override
    public void annotate(IResultSet result) throws AnnotatorException {
        int stackIndex = 1;
        for (IResult r : result) {
            IBlock block = r.getBlock();
            if (!block.hasNode() || !r.hasFailure()) continue;
            this.addStackTrace(block.getNode(), r, stackIndex++);
        }
    }

    protected void addStackTrace(Node node, IResult result, int stackIndex) throws AnnotatorException {
        ParentNode parent;
        ParentNode parentNode = parent = node instanceof ParentNode ? (ParentNode)node : node.getParent();
        if (parent == null) {
            parent = node.getDocument();
        }
        if (parent instanceof Document) {
            parent = ((Document)parent).getRootElement();
        }
        int index = parent.indexOf(node) + 1;
        Element button = new Element("input");
        button.addAttribute(new Attribute("type", "button"));
        button.addAttribute(new Attribute("class", "stackbutton"));
        button.addAttribute(new Attribute("value", " + " + stackIndex));
        button.addAttribute(new Attribute("id", "error" + stackIndex));
        parent.insertChild((Node)button, index++);
        Throwable failure = result.getFailure();
        Element stack = null;
        if (failure instanceof IPresentation) {
            stack = new Element("span");
            stack.appendChild(((IPresentation)((Object)failure)).asNode());
        } else {
            stack = new Element("pre");
            try {
                stack.appendChild(ExceptionUtil.toString(failure));
            }
            catch (IOException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new AnnotatorException(e);
            }
        }
        stack.addAttribute(new Attribute("id", "error" + stackIndex + "_stack"));
        stack.addAttribute(new Attribute("class", "stacktrace"));
        parent.insertChild((Node)stack, index);
    }
}

