/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.annotator.core;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.annotator.AnnotatorException;
import org.specrunner.annotator.IAnnotator;
import org.specrunner.context.IBlock;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritable;
import org.specrunner.util.UtilLog;

public class AnnotatorTitle
implements IAnnotator {
    @Override
    public void annotate(IResultSet result) throws AnnotatorException {
        for (IResult r : result) {
            IBlock block = r.getBlock();
            if (!block.hasNode()) continue;
            Node node = block.getNode();
            String info = this.getInfo(r.getWritable());
            this.addMessage(r, node, info);
            this.addFailure(r, node, info);
        }
    }

    private String getInfo(IWritable wrt) {
        String info = null;
        if (wrt != null && wrt.hasInformation()) {
            info = String.valueOf(wrt.getInformation());
        }
        return info;
    }

    private void addMessage(IResult r, Node node, String info) throws AnnotatorException {
        if (r.hasMessage()) {
            this.addTitle(node, r.getMessage() + (info != null ? ",INFO:" + info : ""), null);
        }
    }

    private void addFailure(IResult r, Node node, String info) throws AnnotatorException {
        if (!r.hasMessage() && r.hasFailure()) {
            this.addTitle(node, r.getFailure().getMessage() + (info != null ? ",INFO:" + info : ""), r.getFailure());
        }
    }

    protected void addTitle(Node node, String message, Throwable error) throws AnnotatorException {
        if (node instanceof Element) {
            Element element = (Element)node;
            Attribute old = element.getAttribute("title");
            if (old == null) {
                Attribute title = new Attribute("title", message);
                element.addAttribute(title);
            } else {
                old.setValue(old.getValue() + "; " + message);
            }
        } else if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Error element is not an Element -> " + (node != null ? node.toXML() : "null"), error);
        }
    }
}

