/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.context.core;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.context.ContextException;
import org.specrunner.context.IBlock;
import org.specrunner.context.IBlockFactory;
import org.specrunner.context.IContext;
import org.specrunner.context.IModel;
import org.specrunner.context.core.BlockImpl;
import org.specrunner.pipeline.IChannel;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.runner.IRunner;
import org.specrunner.source.ISource;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.UtilNode;

public class ContextImpl
extends LinkedList<IBlock>
implements IContext {
    private static final int PARENT = 1;
    private static final int CURRENT = 0;
    protected Deque<ISource> sources = new LinkedList<ISource>();
    protected IChannel channel;
    protected IRunner runner;

    public ContextImpl(ISource source, IRunner runner) throws ContextException {
        this.sources.add(source);
        this.add(new BlockImpl(null, PluginNop.emptyPlugin(), new HashMap<String, Object>()));
        this.setRunner(runner);
    }

    @Override
    public Deque<ISource> getSources() {
        return this.sources;
    }

    @Override
    public ISource getCurrentSource() {
        return this.sources.peek();
    }

    public void setSources(Deque<ISource> sources) {
        this.sources = sources;
    }

    @Override
    public IRunner getRunner() {
        return this.runner;
    }

    public void setRunner(IRunner runner) {
        this.runner = runner;
    }

    @Override
    public void saveGlobal(String global, Object obj) {
        ((IBlock)this.getLast()).getMap().put(global, obj);
    }

    @Override
    public void clearGlobal(String global) {
        ((IBlock)this.getLast()).getMap().remove(global);
    }

    @Override
    public void saveLocal(String local, Object obj) {
        IBlock parentBlock = this.getParentByElement(ParentNode.class);
        if (parentBlock != null) {
            parentBlock.getMap().put(local, obj);
        } else {
            this.saveGlobal(local, obj);
        }
    }

    @Override
    public void clearLocal(String local) {
        IBlock parentBlock = this.getParentByElement(ParentNode.class);
        if (parentBlock != null) {
            parentBlock.getMap().remove(local);
        } else {
            this.clearGlobal(local);
        }
    }

    @Override
    public void saveStrict(String local, Object obj) {
        ((IBlock)this.getFirst()).getMap().put(local, obj);
    }

    @Override
    public void clearStrict(String name) {
        ((IBlock)this.getFirst()).getMap().remove(name);
    }

    @Override
    public void saveScoped(String scope, String local, Object obj) {
        for (int i = 1; i < this.size(); ++i) {
            Node node;
            IBlock g = (IBlock)this.get(i);
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace("saveScope = " + g);
            }
            if (g == null || !((node = g.getNode()) instanceof Element) || !((Element)node).getQualifiedName().equals(scope)) continue;
            g.getMap().put(local, obj);
            break;
        }
    }

    @Override
    public void clearScoped(String scope, String local) {
        for (int i = 1; i < this.size(); ++i) {
            Node node;
            IBlock g = (IBlock)this.get(i);
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace("clearScope = " + g);
            }
            if (g == null || !((node = g.getNode()) instanceof Element) || !((Element)node).getQualifiedName().equals(scope)) continue;
            g.getMap().remove(local);
            break;
        }
    }

    @Override
    public IBlock getByElement(Class<? extends Node> type) {
        return this.findNode(0, type);
    }

    @Override
    public IBlock getParentByElement(Class<? extends Node> type) {
        return this.findNode(1, type);
    }

    protected IBlock findNode(int start, Class<? extends Node> type) {
        for (int i = start; i < this.size(); ++i) {
            IBlock g = (IBlock)this.get(i);
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace((i != 1 ? "getByElement" : "getParentByElement") + " = " + g);
            }
            if (g == null || g.getNode() == null || !type.isAssignableFrom(g.getNode().getClass())) continue;
            return g;
        }
        return null;
    }

    @Override
    public IBlock getByPlugin(Class<? extends IPlugin> type) {
        return this.findPlugin(0, type);
    }

    @Override
    public IBlock getParentByPlugin(Class<? extends IPlugin> type) {
        return this.findPlugin(1, type);
    }

    protected IBlock findPlugin(int start, Class<? extends IPlugin> type) {
        for (int i = start; i < this.size(); ++i) {
            IBlock g = (IBlock)this.get(i);
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace((i != 1 ? "getByPlugin" : "getParentByPlugin") + " = " + g);
            }
            if (g == null || g.getPlugin() == null || !type.isAssignableFrom(g.getPlugin().getClass())) continue;
            return g;
        }
        return null;
    }

    @Override
    public Object getByName(String name) {
        return this.findName(0, name);
    }

    @Override
    public Object getParentByName(String name) {
        return this.findName(1, name);
    }

    protected Object findName(int start, String name) {
        int begin;
        int count = 0;
        int n = begin = name != null ? name.indexOf("_$", 0) : -1;
        while (name != null && begin >= 0) {
            ++count;
            begin = name.indexOf("_$", begin + "_$".length());
        }
        name = name != null ? name.replace("_$", "") : null;
        for (int i = start; i < this.size(); ++i) {
            Object o;
            block7: {
                IBlock g = (IBlock)this.get(i);
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace((i != 1 ? "getByName" : "getParentByName") + " = " + g);
                }
                if (g == null || (o = g.getMap().get(name)) == null) continue;
                if (count > 0) {
                    --count;
                    continue;
                }
                if (o instanceof IModel) {
                    try {
                        return ((IModel)o).getObject(this);
                    }
                    catch (SpecRunnerException e) {
                        if (!UtilLog.LOG.isTraceEnabled()) break block7;
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return o;
        }
        return null;
    }

    @Override
    public Map<String, Object> getObjects() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (IBlock b : this) {
            result.putAll(b.getMap());
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return this.hasNode() || this.hasPlugin();
    }

    @Override
    public boolean hasChildren() {
        return ((IBlock)this.peek()).hasChildren();
    }

    @Override
    public boolean isChanged() {
        return ((IBlock)this.peek()).isChanged();
    }

    @Override
    public void setChanged(boolean changed) {
        ((IBlock)this.peek()).setChanged(changed);
    }

    @Override
    public boolean hasNode() {
        return ((IBlock)this.peek()).hasNode();
    }

    @Override
    public Node getNode() {
        return ((IBlock)this.peek()).getNode();
    }

    @Override
    public void setNode(Node node) {
        this.setChanged(this.getNode() != null && this.getNode() != node);
        ((IBlock)this.peek()).setNode(node);
    }

    @Override
    public boolean hasPlugin() {
        return ((IBlock)this.peek()).hasPlugin();
    }

    @Override
    public IPlugin getPlugin() {
        return ((IBlock)this.peek()).getPlugin();
    }

    @Override
    public void setPlugin(IPlugin plugin) {
        ((IBlock)this.peek()).setPlugin(plugin);
    }

    @Override
    public boolean hasMap() {
        return ((IBlock)this.peek()).hasMap();
    }

    @Override
    public Map<String, Object> getMap() {
        return ((IBlock)this.peek()).getMap();
    }

    @Override
    public void setMap(Map<String, Object> map) {
        ((IBlock)this.peek()).setMap(map);
    }

    @Override
    public IBlock newBlock(Node node, IPlugin plugin) {
        return SRServices.get(IBlockFactory.class).newBlock(node, plugin);
    }

    @Override
    public IBlock newBlock(Node node, IPlugin plugin, Map<String, Object> map) {
        return SRServices.get(IBlockFactory.class).newBlock(node, plugin, map);
    }

    @Override
    public void addMetadata() {
        final IBlock block = (IBlock)this.peek();
        this.saveStrict("$BLOCK", block);
        this.saveStrict("$NODE", new IModel<Node>(){

            @Override
            public Node getObject(IContext context) throws SpecRunnerException {
                return block.getNode();
            }
        });
        this.saveStrict("$PLUGIN", new IModel<IPlugin>(){

            @Override
            public IPlugin getObject(IContext context) throws SpecRunnerException {
                return block.getPlugin();
            }
        });
        this.saveStrict("$TEXT", new IModel<String>(){

            @Override
            public String getObject(IContext context) throws SpecRunnerException {
                return block.getNode().getValue();
            }
        });
        this.saveStrict("$XML", new IModel<String>(){

            @Override
            public String getObject(IContext context) throws SpecRunnerException {
                return block.getNode().toXML();
            }
        });
        this.saveStrict("$INNER_XML", new IModel<String>(){

            @Override
            public String getObject(IContext context) throws SpecRunnerException {
                return UtilNode.getChildrenAsString(block.getNode());
            }
        });
        this.saveStrict("$CONTENT", new IModel<Object>(){

            @Override
            public Object getObject(IContext context) throws SpecRunnerException {
                try {
                    return UtilEvaluator.evaluate(block.getNode().getValue(), context, true);
                }
                catch (Exception e) {
                    throw new SpecRunnerException(e);
                }
            }
        });
        this.saveStrict("$CONTENT_UNSILENT", new IModel<Object>(){

            @Override
            public Object getObject(IContext context) throws SpecRunnerException {
                try {
                    return UtilEvaluator.evaluate(block.getNode().getValue(), context, false);
                }
                catch (Exception e) {
                    throw new SpecRunnerException(e);
                }
            }
        });
    }
}

