/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.converters.Converter;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.IConverter;
import org.specrunner.converters.IConverterManager;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.objects.PluginObjectManager;
import org.specrunner.util.UtilLog;

public final class UtilConverter {
    public static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    private UtilConverter() {
    }

    public static Class<?> getWrapper(Class<?> clazz) {
        Class<?> primitive = PRIMITIVES.get(clazz);
        return primitive == null ? clazz : primitive;
    }

    public static void prepareMethodArguments(Method method, List<Object> arguments) throws PluginException {
        Class<?>[] types = method.getParameterTypes();
        if (types.length != arguments.size()) {
            throw new PluginException(method + " has different number of arguments. Received arguments:" + arguments);
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < types.length; ++i) {
            arguments.add(i, UtilConverter.prepareArgument(method.toString(), parameterAnnotations[i], types[i], arguments.get(i)));
            arguments.remove(i + 1);
        }
    }

    public static Object prepareArgument(String message, Annotation[] annotations, Class<?> type, Object arg) throws PluginException {
        Class<?> tmpType = PRIMITIVES.get(type);
        if (tmpType != null) {
            type = tmpType;
        }
        if (!type.isInstance(arg)) {
            String simpleName = type.getSimpleName().toLowerCase();
            IConverter converter = null;
            Object[] converterArguments = null;
            Converter annotation = UtilConverter.getConverter(annotations);
            IConverterManager cm = SRServices.getConverterManager();
            if (annotation != null) {
                String name = annotation.name();
                if (!name.isEmpty()) {
                    converter = (IConverter)cm.get(name);
                    if (converter == null) {
                        throw new PluginException("Converter named '" + name + "' not found.");
                    }
                } else {
                    Class<? extends IConverter> converterType = annotation.type();
                    if (converterType != IConverter.class) {
                        try {
                            converter = converterType.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new PluginException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new PluginException(e);
                        }
                    }
                    if (converter == null) {
                        converter = (IConverter)cm.get(simpleName);
                    }
                }
                converterArguments = annotation.args();
            } else {
                converter = (IConverter)cm.get(simpleName);
                converterArguments = new Object[]{};
            }
            if (converter == null && PluginObjectManager.get().isBound(type)) {
                converter = (IConverter)cm.get("object");
                converterArguments = new Object[]{type};
            }
            if (converter != null) {
                try {
                    Object tmp;
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(converter + "(" + arg + "," + Arrays.toString(converterArguments) + ")");
                    }
                    if (!type.isInstance(tmp = converter.convert(arg, converterArguments))) {
                        throw new PluginException("Invalid parameter value [" + arg + "] in " + message + ". Expected " + type + ", received: " + tmp + " of type " + tmp.getClass());
                    }
                    return tmp;
                }
                catch (ConverterException e) {
                    throw new PluginException(e);
                }
            }
        }
        return arg;
    }

    public static Converter getConverter(Annotation[] annots) {
        Converter conv = null;
        for (int j = 0; j < annots.length; ++j) {
            if (!(annots[j] instanceof Converter)) continue;
            conv = (Converter)annots[j];
        }
        return conv;
    }

    static {
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
    }
}

