/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import java.util.Arrays;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;

public abstract class AbstractConverterTimeTemplate<T>
extends ConverterNotNullNotEmpty {
    private String[] values;
    private String regexp;

    public AbstractConverterTimeTemplate(String[] values) {
        this.values = values == null ? null : Arrays.copyOf(values, values.length);
    }

    public AbstractConverterTimeTemplate(String regexp) {
        this.regexp = regexp;
    }

    @Override
    public Object convert(Object value, Object[] args) throws ConverterException {
        if (value == null) {
            return null;
        }
        String str = String.valueOf(value);
        if (this.regexp != null && str.matches(this.regexp)) {
            return this.instance();
        }
        if (this.values != null) {
            for (String v : this.values) {
                if (!str.contains(v)) continue;
                return this.instance();
            }
        }
        throw new ConverterException("Invalid value '" + value + "'.");
    }

    protected abstract T instance();
}

