/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;

public class ConverterBooleanTemplate
extends ConverterNotNullNotEmpty {
    private String yes;
    private String no;

    public ConverterBooleanTemplate(String yes, String no) {
        this.yes = yes.toLowerCase().trim();
        this.no = no.toLowerCase().trim();
    }

    @Override
    public Object convert(Object value, Object[] args) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        String tmp = String.valueOf(value).toLowerCase().trim();
        if (this.yes.equals(tmp)) {
            return Boolean.TRUE;
        }
        if (this.no.equals(tmp)) {
            return Boolean.FALSE;
        }
        throw new ConverterException("Value '" + tmp + "' not valid, use \n'" + this.yes + "' or '" + this.no + "'");
    }
}

