/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.specrunner.SRServices;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public class ConverterDatePatternArgs
extends ConverterNotNullNotEmpty {
    protected static ICache<String, SimpleDateFormat> cache = SRServices.get(ICacheFactory.class).newCache(ConverterDatePatternArgs.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convert(Object value, Object[] args) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return value;
        }
        try {
            String pattern = String.valueOf(args[0]);
            ICache<String, SimpleDateFormat> iCache = cache;
            synchronized (iCache) {
                SimpleDateFormat formatter = cache.get(pattern);
                if (formatter == null) {
                    formatter = new SimpleDateFormat(pattern);
                    cache.put(pattern, formatter);
                }
                return formatter.parse(String.valueOf(value));
            }
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }
}

