/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.specrunner.SRServices;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public class ConverterDateTimePatternArgs
extends ConverterNotNullNotEmpty {
    protected static ICache<String, DateTimeFormatter> cache = SRServices.get(ICacheFactory.class).newCache(ConverterDateTimePatternArgs.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convert(Object value, Object[] args) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof DateTime) {
            return value;
        }
        try {
            String pattern = String.valueOf(args[0]);
            ICache<String, DateTimeFormatter> iCache = cache;
            synchronized (iCache) {
                DateTimeFormatter formatter = cache.get(pattern);
                if (formatter == null) {
                    formatter = DateTimeFormat.forPattern((String)pattern);
                    cache.put(pattern, formatter);
                }
                return formatter.parseDateTime(String.valueOf(value));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(e);
        }
    }
}

