/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import java.lang.reflect.Method;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;

public class ConverterEnum
extends ConverterNotNullNotEmpty {
    private static final int ARG_SIZE = 2;

    @Override
    public Object convert(Object obj, Object[] args) throws ConverterException {
        if (obj == null) {
            return null;
        }
        if (args == null || args.length < 2) {
            throw new ConverterException("Converter requires two arguments: 0) the enum class type (class object or name); 1) enum method name passed to compare values.");
        }
        Enum result = null;
        Class<?> clazz = null;
        Object type = args[0];
        try {
            clazz = type instanceof Class ? (Class<?>)type : Class.forName(String.valueOf(type));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        if (!clazz.isEnum()) {
            throw new ConverterException("Class '" + clazz.getName() + "' is not an enumeration.");
        }
        try {
            Enum[] values;
            Class<?> enumType = clazz;
            String name = String.valueOf(args[1]);
            Method method = enumType.getMethod(name, new Class[0]);
            String current = String.valueOf(obj);
            for (Enum e : values = (Enum[])enumType.getEnumConstants()) {
                Object base = method.invoke((Object)e, new Object[0]);
                if (!current.equalsIgnoreCase(String.valueOf(base))) continue;
                result = e;
                break;
            }
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        return result;
    }
}

