/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import java.lang.reflect.Method;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;

public class ConverterEnumValue
extends ConverterNotNullNotEmpty {
    private static final int ARG_SIZE = 3;

    @Override
    public Object convert(Object obj, Object[] args) throws ConverterException {
        Method method;
        String name;
        if (obj == null) {
            return null;
        }
        if (args == null || args.length < 3) {
            throw new ConverterException("Converter requires three arguments: 0) the enum class type (class object or name); 1) enum method name passed to compare values; 2) the enum method to be called for result.");
        }
        Object result = null;
        Class<?> clazz = null;
        Object type = args[0];
        try {
            clazz = type instanceof Class ? (Class<?>)type : Class.forName(String.valueOf(type));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        if (!clazz.isEnum()) {
            throw new ConverterException("Class '" + clazz.getName() + "' is not an enumeration.");
        }
        Class<?> enumType = clazz;
        try {
            Enum[] values;
            name = String.valueOf(args[1]);
            method = enumType.getMethod(name, new Class[0]);
            String current = String.valueOf(obj);
            for (Enum e : values = (Enum[])enumType.getEnumConstants()) {
                Object base = method.invoke((Object)e, new Object[0]);
                if (!current.equalsIgnoreCase(String.valueOf(base))) continue;
                result = e;
                break;
            }
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        if (result != null) {
            try {
                name = String.valueOf(args[2]);
                method = enumType.getMethod(name, new Class[0]);
                result = method.invoke(result, new Object[0]);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
        return result;
    }
}

