/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.converters.core;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.core.ConverterNotNullNotEmpty;

public class ConverterLocalDatePatternTemplate
extends ConverterNotNullNotEmpty {
    private DateTimeFormatter pattern;

    public ConverterLocalDatePatternTemplate(String pattern) {
        this.pattern = DateTimeFormat.forPattern((String)pattern);
    }

    @Override
    public Object convert(Object value, Object[] args) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return value;
        }
        try {
            return this.pattern.parseDateTime(String.valueOf(value)).toLocalDate();
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(e);
        }
    }
}

